/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.ShapeEdge;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.TextGrid;

public class DiagramShape
extends DiagramComponent {
    private static final boolean DEBUG = false;
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_ARROWHEAD = 1;
    public static final int TYPE_POINT_MARKER = 2;
    public static final int TYPE_DOCUMENT = 3;
    public static final int TYPE_STORAGE = 4;
    public static final int TYPE_IO = 5;
    public static final int TYPE_DECISION = 6;
    public static final int TYPE_MANUAL_OPERATION = 7;
    public static final int TYPE_TRAPEZOID = 8;
    public static final int TYPE_ELLIPSE = 9;
    public static final int TYPE_CUSTOM = 9999;
    protected int type = 0;
    private Color fillColor = null;
    private Color strokeColor = Color.black;
    private boolean isClosed = false;
    private boolean isStrokeDashed = false;
    protected ArrayList points = new ArrayList();
    CustomShapeDefinition definition = null;
    private static final float KAPPA = 4.0f * ((float)Math.sqrt(2.0) - 1.0f) / 3.0f;

    public static void main(String[] stringArray) {
    }

    public static DiagramShape createArrowhead(TextGrid textGrid, TextGrid.Cell cell, int n, int n2) {
        if (!textGrid.isArrowhead(cell)) {
            return null;
        }
        if (textGrid.isNorthArrowhead(cell)) {
            return DiagramShape.createNorthArrowhead(textGrid, cell, n, n2);
        }
        if (textGrid.isSouthArrowhead(cell)) {
            return DiagramShape.createSouthArrowhead(textGrid, cell, n, n2);
        }
        if (textGrid.isWestArrowhead(cell)) {
            return DiagramShape.createWestArrowhead(textGrid, cell, n, n2);
        }
        if (textGrid.isEastArrowhead(cell)) {
            return DiagramShape.createEastArrowhead(textGrid, cell, n, n2);
        }
        return null;
    }

    private static DiagramShape createNorthArrowhead(TextGrid textGrid, TextGrid.Cell cell, int n, int n2) {
        if (!textGrid.isNorthArrowhead(cell)) {
            return null;
        }
        DiagramShape diagramShape = new DiagramShape();
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, n), Diagram.getCellMinY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, n), Diagram.getCellMaxY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, n), Diagram.getCellMaxY(cell, n2)));
        diagramShape.setClosed(true);
        diagramShape.setFillColor(Color.black);
        diagramShape.setStrokeColor(Color.black);
        diagramShape.setType(1);
        return diagramShape;
    }

    private static DiagramShape createSouthArrowhead(TextGrid textGrid, TextGrid.Cell cell, int n, int n2) {
        if (!textGrid.isSouthArrowhead(cell)) {
            return null;
        }
        DiagramShape diagramShape = new DiagramShape();
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, n), Diagram.getCellMinY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMidX(cell, n), Diagram.getCellMaxY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, n), Diagram.getCellMinY(cell, n2)));
        diagramShape.setClosed(true);
        diagramShape.setFillColor(Color.black);
        diagramShape.setStrokeColor(Color.black);
        diagramShape.setType(1);
        return diagramShape;
    }

    private static DiagramShape createWestArrowhead(TextGrid textGrid, TextGrid.Cell cell, int n, int n2) {
        if (!textGrid.isWestArrowhead(cell)) {
            return null;
        }
        DiagramShape diagramShape = new DiagramShape();
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, n), Diagram.getCellMinY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, n), Diagram.getCellMidY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, n), Diagram.getCellMaxY(cell, n2)));
        diagramShape.setClosed(true);
        diagramShape.setFillColor(Color.black);
        diagramShape.setStrokeColor(Color.black);
        diagramShape.setType(1);
        return diagramShape;
    }

    private static DiagramShape createEastArrowhead(TextGrid textGrid, TextGrid.Cell cell, int n, int n2) {
        if (!textGrid.isEastArrowhead(cell)) {
            return null;
        }
        DiagramShape diagramShape = new DiagramShape();
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, n), Diagram.getCellMinY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMaxX(cell, n), Diagram.getCellMidY(cell, n2)));
        diagramShape.addToPoints(new ShapePoint(Diagram.getCellMinX(cell, n), Diagram.getCellMaxY(cell, n2)));
        diagramShape.setClosed(true);
        diagramShape.setFillColor(Color.black);
        diagramShape.setStrokeColor(Color.black);
        diagramShape.setType(1);
        return diagramShape;
    }

    public static DiagramShape createSmallLine(TextGrid textGrid, TextGrid.Cell cell, int n, int n2) {
        if (textGrid.isLine(cell)) {
            DiagramShape diagramShape = new DiagramShape();
            if (textGrid.isHorizontalLine(cell)) {
                diagramShape.addToPoints(new ShapePoint(cell.x * n, cell.y * n2 + n2 / 2));
                diagramShape.addToPoints(new ShapePoint(cell.x * n + n - 1, cell.y * n2 + n2 / 2));
            } else if (textGrid.isVerticalLine(cell)) {
                diagramShape.addToPoints(new ShapePoint(cell.x * n + n / 2, cell.y * n2));
                diagramShape.addToPoints(new ShapePoint(cell.x * n + n / 2, cell.y * n2 + n2 - 1));
            }
            return diagramShape;
        }
        return null;
    }

    public void addToPoints(ShapePoint shapePoint) {
        this.points.add(shapePoint);
    }

    public Iterator getPointsIterator() {
        return this.points.iterator();
    }

    public void scale(float f) {
        Iterator iterator = this.getPointsIterator();
        while (iterator.hasNext()) {
            ShapePoint shapePoint = (ShapePoint)iterator.next();
            shapePoint.x *= f;
            shapePoint.y *= f;
        }
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public boolean isFilled() {
        return this.fillColor != null;
    }

    public void setIsNotFilled() {
        this.fillColor = null;
    }

    public boolean isPointLinesEnd(ShapePoint shapePoint) {
        if (this.isClosed()) {
            return false;
        }
        if (shapePoint == this.points.get(0)) {
            return true;
        }
        return shapePoint == this.points.get(this.points.size() - 1);
    }

    public boolean isRectangle() {
        if (this.points.size() != 4) {
            return false;
        }
        ShapePoint shapePoint = (ShapePoint)this.points.get(0);
        ShapePoint shapePoint2 = (ShapePoint)this.points.get(1);
        ShapePoint shapePoint3 = (ShapePoint)this.points.get(2);
        ShapePoint shapePoint4 = (ShapePoint)this.points.get(3);
        return shapePoint.isInLineWith(shapePoint2) && shapePoint2.isInLineWith(shapePoint3) && shapePoint3.isInLineWith(shapePoint4) && shapePoint4.isInLineWith(shapePoint);
    }

    public boolean isSmallerThan(DiagramShape diagramShape) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = diagramShape.getBounds();
        int n = rectangle.height * rectangle.width;
        int n2 = rectangle2.height * rectangle2.width;
        return n < n2;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public void printDebug() {
        System.out.print("DiagramShape: ");
        System.out.println(this.points.size() + " points");
    }

    public ArrayList getPoints() {
        return this.points;
    }

    public ShapePoint getPoint(int n) {
        return (ShapePoint)this.points.get(n);
    }

    public void setPoint(int n, ShapePoint shapePoint) {
        this.points.set(n, shapePoint);
    }

    public boolean equals(Object object) {
        Cloneable cloneable;
        DiagramShape diagramShape = null;
        if (!(object instanceof DiagramShape)) {
            return false;
        }
        diagramShape = (DiagramShape)object;
        if (this.getPoints().size() != diagramShape.getPoints().size()) {
            return false;
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = this.getPointsIterator();
        while (iterator.hasNext()) {
            cloneable = (ShapePoint)iterator.next();
            hashMap.put("" + (int)((ShapePoint)cloneable).x + "," + (int)((ShapePoint)cloneable).y, null);
        }
        cloneable = new HashMap();
        iterator = diagramShape.getPointsIterator();
        while (iterator.hasNext()) {
            Object object2 = (ShapePoint)iterator.next();
            ((HashMap)cloneable).put("" + (int)((ShapePoint)object2).x + "," + (int)((ShapePoint)object2).y, null);
        }
        for (Object object2 : hashMap.keySet()) {
            if (((HashMap)cloneable).containsKey(object2)) continue;
            return false;
        }
        return true;
    }

    public GeneralPath makeIntoPath() {
        int n = this.getPoints().size();
        if (n < 2) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath();
        ShapePoint shapePoint = (ShapePoint)this.getPoints().get(0);
        generalPath.moveTo((int)shapePoint.x, (int)shapePoint.y);
        for (int i = 1; i < n; ++i) {
            shapePoint = (ShapePoint)this.getPoints().get(i);
            generalPath.lineTo((int)shapePoint.x, (int)shapePoint.y);
        }
        if (this.isClosed() && n > 2) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public GeneralPath makeMarkerPath(Diagram diagram) {
        if (this.points.size() != 1) {
            return null;
        }
        ShapePoint shapePoint = this.getPoint(0);
        float f = 0.7f * (float)Math.min(diagram.getCellWidth(), diagram.getCellHeight());
        return new GeneralPath(new Ellipse2D.Float(shapePoint.x - f / 2.0f, shapePoint.y - f / 2.0f, f, f));
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.makeIntoPath().getBounds();
        return rectangle;
    }

    public GeneralPath makeIntoRenderPath(Diagram diagram) {
        ShapePoint shapePoint;
        ShapePoint shapePoint2;
        int n = this.getPoints().size();
        if (this.getType() == 2) {
            return this.makeMarkerPath(diagram);
        }
        if (this.getType() == 3 && this.points.size() == 4) {
            return this.makeDocumentPath(diagram);
        }
        if (this.getType() == 4 && this.points.size() == 4) {
            return this.makeStoragePath(diagram);
        }
        if (this.getType() == 5 && this.points.size() == 4) {
            return this.makeIOPath(diagram);
        }
        if (this.getType() == 6 && this.points.size() == 4) {
            return this.makeDecisionPath(diagram);
        }
        if (this.getType() == 7 && this.points.size() == 4) {
            return this.makeTrapezoidPath(diagram, true);
        }
        if (this.getType() == 8 && this.points.size() == 4) {
            return this.makeTrapezoidPath(diagram, false);
        }
        if (this.getType() == 9 && this.points.size() == 4) {
            return this.makeEllipsePath(diagram);
        }
        if (n < 2) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath();
        ShapePoint shapePoint3 = (ShapePoint)this.getPoints().get(0);
        TextGrid.Cell cell = diagram.getCellFor(shapePoint3);
        ShapePoint shapePoint4 = (ShapePoint)this.getPoints().get(n - 1);
        ShapePoint shapePoint5 = (ShapePoint)this.getPoints().get(1);
        if (shapePoint3.getType() == 0) {
            generalPath.moveTo((int)shapePoint3.x, (int)shapePoint3.y);
        } else if (shapePoint3.getType() == 1) {
            shapePoint2 = this.getCellEdgePointBetween(shapePoint3, shapePoint4, diagram);
            shapePoint = this.getCellEdgePointBetween(shapePoint3, shapePoint5, diagram);
            generalPath.moveTo(shapePoint2.x, shapePoint2.y);
            generalPath.quadTo(shapePoint3.x, shapePoint3.y, shapePoint.x, shapePoint.y);
        }
        for (int i = 1; i < n; ++i) {
            shapePoint4 = shapePoint3;
            shapePoint3 = (ShapePoint)this.getPoints().get(i);
            shapePoint5 = i < n - 1 ? (ShapePoint)this.getPoints().get(i + 1) : (ShapePoint)this.getPoints().get(0);
            cell = diagram.getCellFor(shapePoint3);
            if (shapePoint3.getType() == 0) {
                generalPath.lineTo((int)shapePoint3.x, (int)shapePoint3.y);
                continue;
            }
            if (shapePoint3.getType() != 1) continue;
            shapePoint2 = this.getCellEdgePointBetween(shapePoint3, shapePoint4, diagram);
            shapePoint = this.getCellEdgePointBetween(shapePoint3, shapePoint5, diagram);
            generalPath.lineTo(shapePoint2.x, shapePoint2.y);
            generalPath.quadTo(shapePoint3.x, shapePoint3.y, shapePoint.x, shapePoint.y);
            if (shapePoint5.getType() == 0) {
                generalPath.lineTo(shapePoint5.x, shapePoint5.y);
                continue;
            }
            if (shapePoint5.getType() != 1) continue;
            shapePoint2 = this.getCellEdgePointBetween(shapePoint5, shapePoint3, diagram);
            generalPath.lineTo(shapePoint2.x, shapePoint2.y);
        }
        if (this.isClosed() && n > 2) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public ArrayList getEdges() {
        Object object;
        ShapePoint shapePoint;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.points.size() == 1) {
            return arrayList;
        }
        int n = this.points.size();
        for (int i = 0; i < n - 1; ++i) {
            shapePoint = (ShapePoint)this.points.get(i);
            object = (ShapePoint)this.points.get(i + 1);
            ShapeEdge shapeEdge = new ShapeEdge(shapePoint, (ShapePoint)object, this);
            arrayList.add(shapeEdge);
        }
        if (this.isClosed()) {
            ShapePoint shapePoint2 = (ShapePoint)this.points.get(0);
            shapePoint = (ShapePoint)this.points.get(this.points.size() - 1);
            object = new ShapeEdge(shapePoint, shapePoint2, this);
            arrayList.add(object);
        }
        return arrayList;
    }

    public ShapePoint getCellEdgePointBetween(ShapePoint shapePoint, ShapePoint shapePoint2, Diagram diagram) {
        if (shapePoint == null || shapePoint2 == null || diagram == null) {
            throw new IllegalArgumentException("None of the parameters can be null");
        }
        if (shapePoint.equals(shapePoint2)) {
            throw new IllegalArgumentException("The two points cannot be the same");
        }
        ShapePoint shapePoint3 = null;
        TextGrid.Cell cell = diagram.getCellFor(shapePoint);
        if (cell == null) {
            throw new RuntimeException("Upexpected error, cannot find cell corresponding to point " + shapePoint + " for diagram " + diagram);
        }
        if (shapePoint2.isNorthOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x, diagram.getCellMinY(cell));
        } else if (shapePoint2.isSouthOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x, diagram.getCellMaxY(cell));
        } else if (shapePoint2.isWestOf(shapePoint)) {
            shapePoint3 = new ShapePoint(diagram.getCellMinX(cell), shapePoint.y);
        } else if (shapePoint2.isEastOf(shapePoint)) {
            shapePoint3 = new ShapePoint(diagram.getCellMaxX(cell), shapePoint.y);
        }
        if (shapePoint3 == null) {
            throw new RuntimeException("Upexpected error, cannot find cell edge point for points " + shapePoint + " and " + shapePoint2 + " for diagram " + diagram);
        }
        return shapePoint3;
    }

    public ShapePoint getCellEdgeProjectionPointBetween(ShapePoint shapePoint, ShapePoint shapePoint2, Diagram diagram) {
        if (shapePoint == null || shapePoint2 == null || diagram == null) {
            throw new IllegalArgumentException("None of the parameters can be null");
        }
        if (shapePoint.equals(shapePoint2)) {
            throw new IllegalArgumentException("The two points cannot be the same: " + shapePoint + " and " + shapePoint2 + " passed");
        }
        ShapePoint shapePoint3 = null;
        TextGrid.Cell cell = diagram.getCellFor(shapePoint);
        if (cell == null) {
            throw new RuntimeException("Upexpected error, cannot find cell corresponding to point " + shapePoint + " for diagram " + diagram);
        }
        if (shapePoint2.isNorthOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x, diagram.getCellMaxY(cell));
        } else if (shapePoint2.isSouthOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x, diagram.getCellMinY(cell));
        } else if (shapePoint2.isWestOf(shapePoint)) {
            shapePoint3 = new ShapePoint(diagram.getCellMaxX(cell), shapePoint.y);
        } else if (shapePoint2.isEastOf(shapePoint)) {
            shapePoint3 = new ShapePoint(diagram.getCellMinX(cell), shapePoint.y);
        }
        if (shapePoint3 == null) {
            throw new RuntimeException("Upexpected error, cannot find cell edge point for points " + shapePoint + " and " + shapePoint2 + " for diagram " + diagram);
        }
        return shapePoint3;
    }

    public boolean contains(ShapePoint shapePoint) {
        GeneralPath generalPath = this.makeIntoPath();
        if (generalPath != null) {
            return generalPath.contains(shapePoint);
        }
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        GeneralPath generalPath = this.makeIntoPath();
        if (generalPath != null) {
            return generalPath.contains(rectangle2D);
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        GeneralPath generalPath = this.makeIntoPath();
        if (generalPath != null) {
            return generalPath.intersects(rectangle2D);
        }
        return false;
    }

    public boolean dropsShadow() {
        return this.isClosed() && this.getType() != 1 && this.getType() != 2 && !this.isStrokeDashed();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void moveEndsToCellEdges(TextGrid textGrid, Diagram diagram) {
        if (this.isClosed()) {
            return;
        }
        ShapePoint shapePoint = (ShapePoint)this.points.get(0);
        ShapePoint shapePoint2 = (ShapePoint)this.points.get(1);
        ShapePoint shapePoint3 = this.getCellEdgeProjectionPointBetween(shapePoint, shapePoint2, diagram);
        shapePoint.moveTo(shapePoint3);
        shapePoint = (ShapePoint)this.points.get(this.points.size() - 1);
        shapePoint2 = (ShapePoint)this.points.get(this.points.size() - 2);
        shapePoint3 = this.getCellEdgeProjectionPointBetween(shapePoint, shapePoint2, diagram);
        shapePoint.moveTo(shapePoint3);
    }

    public void connectEndsToAnchors(TextGrid textGrid, Diagram diagram) {
        if (this.isClosed()) {
            return;
        }
        ShapePoint shapePoint = (ShapePoint)this.points.get(0);
        ShapePoint shapePoint2 = (ShapePoint)this.points.get(1);
        this.connectEndToAnchors(textGrid, diagram, shapePoint2, shapePoint);
        shapePoint = (ShapePoint)this.points.get(this.points.size() - 1);
        shapePoint2 = (ShapePoint)this.points.get(this.points.size() - 2);
        this.connectEndToAnchors(textGrid, diagram, shapePoint2, shapePoint);
    }

    private void connectEndToAnchors(TextGrid textGrid, Diagram diagram, ShapePoint shapePoint, ShapePoint shapePoint2) {
        if (this.isClosed()) {
            return;
        }
        TextGrid.Cell cell = DiagramShape.getPossibleAnchorCell(shapePoint2, shapePoint, diagram);
        if (textGrid.isArrowhead(cell)) {
            shapePoint2.x = diagram.getCellMidX(cell);
            shapePoint2.y = diagram.getCellMidY(cell);
            shapePoint2.setLocked(true);
        } else if (textGrid.isCorner(cell) || textGrid.isIntersection(cell)) {
            shapePoint2.x = diagram.getCellMidX(cell);
            shapePoint2.y = diagram.getCellMidY(cell);
            shapePoint2.setLocked(true);
        }
    }

    private static TextGrid.Cell getPossibleAnchorCell(ShapePoint shapePoint, ShapePoint shapePoint2, Diagram diagram) {
        ShapePoint shapePoint3 = null;
        if (shapePoint2.isNorthOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x, shapePoint.y + (float)diagram.getCellHeight());
        }
        if (shapePoint2.isSouthOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x, shapePoint.y - (float)diagram.getCellHeight());
        }
        if (shapePoint2.isWestOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x + (float)diagram.getCellWidth(), shapePoint.y);
        }
        if (shapePoint2.isEastOf(shapePoint)) {
            shapePoint3 = new ShapePoint(shapePoint.x - (float)diagram.getCellWidth(), shapePoint.y);
        }
        return diagram.getCellFor(shapePoint3);
    }

    public String toString() {
        String string = "DiagramShape, " + this.points.size() + " points: ";
        Iterator iterator = this.getPointsIterator();
        while (iterator.hasNext()) {
            ShapePoint shapePoint = (ShapePoint)iterator.next();
            string = string + shapePoint;
            if (!iterator.hasNext()) continue;
            string = string + " ";
        }
        return string;
    }

    public boolean isStrokeDashed() {
        return this.isStrokeDashed;
    }

    public void setStrokeDashed(boolean bl) {
        this.isStrokeDashed = bl;
    }

    private GeneralPath makeStoragePath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle rectangle = this.makeIntoPath().getBounds();
        ShapePoint shapePoint = new ShapePoint((float)rectangle.getMinX(), (float)rectangle.getMinY());
        ShapePoint shapePoint2 = new ShapePoint((float)rectangle.getMaxX(), (float)rectangle.getMinY());
        ShapePoint shapePoint3 = new ShapePoint((float)rectangle.getMaxX(), (float)rectangle.getMaxY());
        ShapePoint shapePoint4 = new ShapePoint((float)rectangle.getMinX(), (float)rectangle.getMaxY());
        ShapePoint shapePoint5 = new ShapePoint((float)rectangle.getCenterX(), (float)rectangle.getMinY());
        ShapePoint shapePoint6 = new ShapePoint((float)rectangle.getCenterX(), (float)rectangle.getMaxY());
        float f = rectangle.width;
        float f2 = 0.75f * (float)diagram.getCellHeight();
        float f3 = rectangle.width / 6;
        float f4 = diagram.getCellHeight() / 2;
        float f5 = 10 * diagram.getCellHeight() / 14;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(shapePoint.x, shapePoint.y);
        generalPath.curveTo(shapePoint.x + f3, shapePoint.y + f4, shapePoint2.x - f3, shapePoint2.y + f4, shapePoint2.x, shapePoint2.y);
        generalPath.curveTo(shapePoint2.x - f3, shapePoint2.y - f4, shapePoint.x + f3, shapePoint.y - f4, shapePoint.x, shapePoint.y);
        generalPath.moveTo(shapePoint.x, shapePoint.y);
        generalPath.lineTo(shapePoint4.x, shapePoint4.y);
        generalPath.curveTo(shapePoint4.x + f3, shapePoint4.y + f5, shapePoint3.x - f3, shapePoint3.y + f5, shapePoint3.x, shapePoint3.y);
        generalPath.lineTo(shapePoint2.x, shapePoint2.y);
        return generalPath;
    }

    private GeneralPath makeDocumentPath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle rectangle = this.makeIntoPath().getBounds();
        ShapePoint shapePoint = new ShapePoint((float)rectangle.getMinX(), (float)rectangle.getMinY());
        ShapePoint shapePoint2 = new ShapePoint((float)rectangle.getMaxX(), (float)rectangle.getMinY());
        ShapePoint shapePoint3 = new ShapePoint((float)rectangle.getMaxX(), (float)rectangle.getMaxY());
        ShapePoint shapePoint4 = new ShapePoint((float)rectangle.getMinX(), (float)rectangle.getMaxY());
        ShapePoint shapePoint5 = new ShapePoint((float)rectangle.getCenterX(), (float)rectangle.getMaxY());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(shapePoint.x, shapePoint.y);
        generalPath.lineTo(shapePoint2.x, shapePoint2.y);
        generalPath.lineTo(shapePoint3.x, shapePoint3.y);
        int n = rectangle.width / 6;
        int n2 = rectangle.height / 8;
        generalPath.quadTo(shapePoint5.x + (float)n, shapePoint5.y - (float)n2, shapePoint5.x, shapePoint5.y);
        generalPath.quadTo(shapePoint5.x - (float)n, shapePoint5.y + (float)n2, shapePoint4.x, shapePoint4.y);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath makeEllipsePath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle rectangle = this.makeIntoPath().getBounds();
        float f = (float)rectangle.getWidth() * 0.5f * KAPPA;
        float f2 = (float)rectangle.getHeight() * 0.5f * KAPPA;
        ShapePoint shapePoint = new ShapePoint((float)rectangle.getCenterX(), (float)rectangle.getCenterY());
        ShapePoint shapePoint2 = new ShapePoint((float)rectangle.getMinX(), (float)shapePoint.getY());
        ShapePoint shapePoint3 = new ShapePoint((float)rectangle.getMaxX(), (float)shapePoint.getY());
        ShapePoint shapePoint4 = new ShapePoint((float)shapePoint.getX(), (float)rectangle.getMinY());
        ShapePoint shapePoint5 = new ShapePoint((float)shapePoint.getX(), (float)rectangle.getMaxY());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(shapePoint4.x, shapePoint4.y);
        generalPath.curveTo(shapePoint4.x + f, shapePoint4.y, shapePoint3.x, shapePoint3.y - f2, shapePoint3.x, shapePoint3.y);
        generalPath.curveTo(shapePoint3.x, shapePoint3.y + f2, shapePoint5.x + f, shapePoint5.y, shapePoint5.x, shapePoint5.y);
        generalPath.curveTo(shapePoint5.x - f, shapePoint5.y, shapePoint2.x, shapePoint2.y + f2, shapePoint2.x, shapePoint2.y);
        generalPath.curveTo(shapePoint2.x, shapePoint2.y - f2, shapePoint4.x - f, shapePoint4.y, shapePoint4.x, shapePoint4.y);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath makeTrapezoidPath(Diagram diagram, boolean bl) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle rectangle = this.makeIntoPath().getBounds();
        float f = 0.7f * (float)diagram.getCellWidth();
        if (bl) {
            f = -f;
        }
        ShapePoint shapePoint = new ShapePoint((float)rectangle.getMinX() + f, (float)rectangle.getMinY());
        ShapePoint shapePoint2 = new ShapePoint((float)rectangle.getMaxX() - f, (float)rectangle.getMinY());
        ShapePoint shapePoint3 = new ShapePoint((float)rectangle.getMaxX() + f, (float)rectangle.getMaxY());
        ShapePoint shapePoint4 = new ShapePoint((float)rectangle.getMinX() - f, (float)rectangle.getMaxY());
        ShapePoint shapePoint5 = new ShapePoint((float)rectangle.getCenterX(), (float)rectangle.getMaxY());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(shapePoint.x, shapePoint.y);
        generalPath.lineTo(shapePoint2.x, shapePoint2.y);
        generalPath.lineTo(shapePoint3.x, shapePoint3.y);
        generalPath.lineTo(shapePoint4.x, shapePoint4.y);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath makeDecisionPath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle rectangle = this.makeIntoPath().getBounds();
        ShapePoint shapePoint = new ShapePoint((float)rectangle.getCenterX(), (float)rectangle.getCenterY());
        ShapePoint shapePoint2 = new ShapePoint((float)rectangle.getMinX(), (float)shapePoint.getY());
        ShapePoint shapePoint3 = new ShapePoint((float)rectangle.getMaxX(), (float)shapePoint.getY());
        ShapePoint shapePoint4 = new ShapePoint((float)shapePoint.getX(), (float)rectangle.getMinY());
        ShapePoint shapePoint5 = new ShapePoint((float)shapePoint.getX(), (float)rectangle.getMaxY());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(shapePoint2.x, shapePoint2.y);
        generalPath.lineTo(shapePoint4.x, shapePoint4.y);
        generalPath.lineTo(shapePoint3.x, shapePoint3.y);
        generalPath.lineTo(shapePoint5.x, shapePoint5.y);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath makeIOPath(Diagram diagram) {
        if (this.points.size() != 4) {
            return null;
        }
        Rectangle rectangle = this.makeIntoPath().getBounds();
        ShapePoint shapePoint = new ShapePoint((float)rectangle.getMinX(), (float)rectangle.getMinY());
        ShapePoint shapePoint2 = new ShapePoint((float)rectangle.getMaxX(), (float)rectangle.getMinY());
        ShapePoint shapePoint3 = new ShapePoint((float)rectangle.getMaxX(), (float)rectangle.getMaxY());
        ShapePoint shapePoint4 = new ShapePoint((float)rectangle.getMinX(), (float)rectangle.getMaxY());
        float f = diagram.getCellWidth() / 2;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(shapePoint.x + f, shapePoint.y);
        generalPath.lineTo(shapePoint2.x + f, shapePoint2.y);
        generalPath.lineTo(shapePoint3.x - f, shapePoint3.y);
        generalPath.lineTo(shapePoint4.x - f, shapePoint4.y);
        generalPath.closePath();
        return generalPath;
    }

    public CustomShapeDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(CustomShapeDefinition customShapeDefinition) {
        this.definition = customShapeDefinition;
    }
}

