/*
 * Decompiled with CFR 0.152.
 */
package gma.gsa;

import gma.AxisTick;
import gma.MapPoint;
import gma.gcalign.GCalign;
import gma.gsa.AlignedBlock;
import gma.gsa.Segment;
import gma.util.InputFileHandler;
import gma.util.OutputFileHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class GSA {
    public static final String GSA = "gsa";
    public static final String BACK_OFF = "backOff";
    public Properties properties = new Properties();
    Map xToYSegmentMap = new HashMap();
    Map yToXSegmentMap = new HashMap();
    Map leftHash = new HashMap();
    Map rightHash = new HashMap();

    public GSA(String[] args) {
        try {
            this.parseArguments(args);
        }
        catch (IllegalArgumentException e) {
            this.printUsage();
            System.exit(1);
        }
    }

    public GSA(Properties properties) {
        this.properties = properties;
    }

    private String formArgumentUsage(String argument, boolean isRequired, String example) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t").append("-").append(argument).append(" ").append(argument).append("\n");
        if (isRequired) {
            buffer.append("\t").append("required argument; ");
        } else {
            buffer.append("\t").append("optional argument; ");
        }
        buffer.append("e.g., ").append("-").append(argument).append(" ").append(example).append("\n\n");
        return buffer.toString();
    }

    private void printUsage() {
        StringBuffer buffer = new StringBuffer("Usage: java gma.gsa.GSA [arguments]\n\n");
        buffer.append("where [arguments] are:\n\n");
        buffer.append(this.formArgumentUsage("properties", true, "./GSA.properties"));
        buffer.append(this.formArgumentUsage("xAxisFile", false, "./french.txt"));
        buffer.append(this.formArgumentUsage("yAxisFile", false, "./english.txt"));
        buffer.append(this.formArgumentUsage("simr.outputFile", false, "./simrOutput.txt"));
        buffer.append(this.formArgumentUsage("gsa.outputFile", false, "./gsaOutput.txt"));
        System.err.println(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseArguments(String[] args) throws IllegalArgumentException {
        InputStream in = null;
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even.");
        }
        for (int index = 0; index < args.length; ++index) {
            if (args[index].equals("-properties")) {
                in = new BufferedInputStream(new FileInputStream(args[++index]));
                this.properties.load(in);
                Object var6_7 = null;
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                continue;
                {
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        System.exit(1);
                        var6_7 = null;
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                        var6_7 = null;
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            if (args[index].equals("-xAxisFile")) {
                this.properties.put("xAxisFile", args[++index]);
                continue;
            }
            if (args[index].equals("-yAxisFile")) {
                this.properties.put("yAxisFile", args[++index]);
                continue;
            }
            if (args[index].equals("-simr.outputFile")) {
                this.properties.put("simr.outputFile", args[++index]);
                continue;
            }
            if (args[index].equals("-gsa.outputFile")) {
                this.properties.put("gsa.outputFile", args[++index]);
                continue;
            }
            throw new IllegalArgumentException(args[index] + "is an invalid argument.");
        }
        if (in == null) {
            throw new IllegalArgumentException("Property file must be specified at the command line.");
        }
    }

    public List generateAlignedBlocks() {
        List xAxisSegments = this.generateSegments("xAxisFile");
        List yAxisSegments = this.generateSegments("yAxisFile");
        List mapPoints = this.generateMapPoints();
        List alignedBlocks = this.generateAlignedBlocks(xAxisSegments, yAxisSegments, mapPoints);
        this.backoffAlignment(alignedBlocks);
        this.gcAlign(alignedBlocks);
        return alignedBlocks;
    }

    private List generateSegments(String axisFileProperty) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int counter = -1;
        float startPosition = 0.0f;
        float endPosition = 0.0f;
        float length = 0.0f;
        float prevEndPosition = 0.0f;
        boolean blank = true;
        InputFileHandler input = new InputFileHandler(this.properties.getProperty(axisFileProperty));
        while (input.hasLine()) {
            String line = input.nextLine();
            StringTokenizer tokenizer = new StringTokenizer(line);
            for (int i = 0; i < 1; ++i) {
                float tempEndPosition = Float.parseFloat(tokenizer.nextToken());
                if (tokenizer.nextToken().equals(this.properties.getProperty("eosMarker"))) {
                    length = blank ? 0.0f : tempEndPosition - prevEndPosition;
                    endPosition = tempEndPosition;
                    prevEndPosition = tempEndPosition;
                    blank = true;
                    Segment segment = new Segment(++counter, startPosition, endPosition, length);
                    segments.add(segment);
                    continue;
                }
                blank = false;
            }
            startPosition = endPosition;
        }
        input.close();
        return segments;
    }

    private List generateMapPoints() {
        ArrayList<MapPoint> mapPoints = new ArrayList<MapPoint>();
        InputFileHandler input = new InputFileHandler(this.properties.getProperty("simr.outputFile"));
        while (input.hasLine()) {
            String line = input.nextLine();
            StringTokenizer st = new StringTokenizer(line);
            AxisTick xAxisTick = new AxisTick(-1, Float.parseFloat(st.nextToken()), null);
            AxisTick yAxisTick = new AxisTick(-1, Float.parseFloat(st.nextToken()), null);
            MapPoint mapPoint = new MapPoint(xAxisTick, yAxisTick);
            mapPoints.add(mapPoint);
        }
        return mapPoints;
    }

    private void hcouple(Segment hSegment) {
        this.leftHash.put(hSegment, "true");
        List ySegments = null;
        ySegments = (List)this.xToYSegmentMap.get(hSegment);
        for (int vind = 0; vind < ySegments.size(); ++vind) {
            Segment vSegment = (Segment)ySegments.get(vind);
            if (this.rightHash.containsKey(vSegment)) continue;
            this.vcouple(vSegment);
        }
    }

    private void vcouple(Segment vSegment) {
        this.rightHash.put(vSegment, "true");
        List xSegments = null;
        xSegments = (List)this.yToXSegmentMap.get(vSegment);
        for (int hind = 0; hind < xSegments.size(); ++hind) {
            Segment hSegment = (Segment)xSegments.get(hind);
            if (this.leftHash.containsKey(hSegment)) continue;
            this.hcouple(hSegment);
        }
    }

    private List generateAlignedBlocks(List xAxisSegments, List yAxisSegments, List mapPoints) {
        int xSegmentIndex = 0;
        int ySegmentIndex = 0;
        Iterator mapPointIter = mapPoints.iterator();
        Segment xSegment = null;
        Segment ySegment = (Segment)yAxisSegments.get(ySegmentIndex);
        MapPoint mapPoint = null;
        boolean needNewXSegment = true;
        while (xSegmentIndex < xAxisSegments.size() - 1 || ySegmentIndex < yAxisSegments.size()) {
            if (needNewXSegment) {
                xSegment = (Segment)xAxisSegments.get(xSegmentIndex);
                ++xSegmentIndex;
                needNewXSegment = false;
            }
            if (mapPoint == null) {
                if (!mapPointIter.hasNext()) break;
                mapPoint = (MapPoint)mapPointIter.next();
            }
            if (xSegment.contains(mapPoint, true) == 0) {
                while (ySegment.contains(mapPoint, false) == -1) {
                    ySegment = (Segment)yAxisSegments.get(--ySegmentIndex);
                }
                while (ySegment.contains(mapPoint, false) == 1) {
                    ySegment = (Segment)yAxisSegments.get(++ySegmentIndex);
                }
                List<Segment> ySegments = null;
                if (this.xToYSegmentMap.containsKey(xSegment)) {
                    ySegments = (List)this.xToYSegmentMap.get(xSegment);
                    if (ySegments.contains(ySegment)) {
                        mapPoint = null;
                        continue;
                    }
                    for (int listIndex = 0; listIndex < ySegments.size(); ++listIndex) {
                        if (ySegment.compareTo(ySegments.get(listIndex)) != -1) continue;
                        ySegments.add(listIndex, ySegment);
                        break;
                    }
                    if (ySegment.compareTo(ySegments.get(ySegments.size() - 1)) == 1) {
                        ySegments.add(ySegment);
                    }
                } else {
                    ySegments = new LinkedList<Segment>();
                    ySegments.add(ySegment);
                }
                if (xSegment.getIndex() > 0) {
                    this.xToYSegmentMap.put(xSegment, ySegments);
                }
                List<Segment> xSegments = null;
                if (this.yToXSegmentMap.containsKey(ySegment)) {
                    xSegments = (List)this.yToXSegmentMap.get(ySegment);
                    for (int listIndex = 0; listIndex < xSegments.size(); ++listIndex) {
                        if (xSegment.compareTo(xSegments.get(listIndex)) != -1) continue;
                        xSegments.add(listIndex, xSegment);
                        break;
                    }
                    if (xSegment.compareTo(xSegments.get(xSegments.size() - 1)) == 1) {
                        xSegments.add(xSegment);
                    }
                } else {
                    xSegments = new LinkedList<Segment>();
                    xSegments.add(xSegment);
                }
                if (ySegment.getIndex() > 0) {
                    this.yToXSegmentMap.put(ySegment, xSegments);
                }
                mapPoint = null;
                continue;
            }
            needNewXSegment = true;
        }
        ArrayList<AlignedBlock> alignedBlocks = new ArrayList<AlignedBlock>();
        xSegmentIndex = 1;
        ySegmentIndex = 1;
        xSegment = (Segment)xAxisSegments.get(xSegmentIndex);
        ySegment = (Segment)yAxisSegments.get(ySegmentIndex);
        int maxhseg = xAxisSegments.size() - 1;
        int maxvseg = yAxisSegments.size() - 1;
        AlignedBlock alignedBlock = new AlignedBlock();
        boolean leftind = true;
        boolean rightind = true;
        while (xSegmentIndex <= maxhseg || ySegmentIndex <= maxvseg) {
            LinkedList thisYBlock;
            ArrayList thisleft = new ArrayList();
            ArrayList thisright = new ArrayList();
            while (!this.xToYSegmentMap.containsKey(xSegment) && xSegmentIndex < maxhseg) {
                if (xSegment.getLength() > 0.0f) {
                    alignedBlock.addSegment(xSegment, true);
                }
                xSegment = (Segment)xAxisSegments.get(++xSegmentIndex);
            }
            while (!this.yToXSegmentMap.containsKey(ySegment) && ySegmentIndex < maxvseg) {
                if (ySegment.getLength() > 0.0f) {
                    alignedBlock.addSegment(ySegment, false);
                }
                ySegment = (Segment)yAxisSegments.get(++ySegmentIndex);
            }
            if (alignedBlock.hasSegments(true) || alignedBlock.hasSegments(false)) {
                List xSegBlock = alignedBlock.getSegments(true, true);
                List ySegBlock = alignedBlock.getSegments(false, true);
                alignedBlocks.add(alignedBlock.copy());
                alignedBlock.clear();
                continue;
            }
            if (xSegmentIndex > maxhseg && ySegmentIndex > maxvseg) continue;
            this.leftHash.clear();
            this.rightHash.clear();
            if (xSegmentIndex <= maxhseg) {
                Segment hSegment = (Segment)xAxisSegments.get(xSegmentIndex);
                this.hcouple(hSegment);
            }
            if (ySegmentIndex <= maxvseg) {
                Segment vSegment = (Segment)yAxisSegments.get(ySegmentIndex);
                this.vcouple(vSegment);
            }
            Iterator leftHashIter = this.leftHash.keySet().iterator();
            while (leftHashIter.hasNext()) {
                alignedBlock.addSegment((Segment)leftHashIter.next(), true);
            }
            Iterator rightHashIter = this.rightHash.keySet().iterator();
            while (rightHashIter.hasNext()) {
                alignedBlock.addSegment((Segment)rightHashIter.next(), false);
            }
            LinkedList thisXBlock = new LinkedList(alignedBlock.getSegments(true, false));
            if (thisXBlock.size() > 0) {
                int start = ((Segment)thisXBlock.get(0)).getIndex();
                int finish = ((Segment)thisXBlock.get(thisXBlock.size() - 1)).getIndex();
                for (int i = start; i <= finish; ++i) {
                    Segment tempXSegment = (Segment)xAxisSegments.get(i);
                    if (!(tempXSegment.getLength() > 0.0f)) continue;
                    alignedBlock.addSegment(tempXSegment, true);
                }
            }
            if ((thisYBlock = new LinkedList(alignedBlock.getSegments(false, false))).size() > 0) {
                int start = ((Segment)thisYBlock.get(0)).getIndex();
                int finish = ((Segment)thisYBlock.get(thisYBlock.size() - 1)).getIndex();
                for (int i = start; i <= finish; ++i) {
                    Segment tempYSegment = (Segment)yAxisSegments.get(i);
                    if (!(tempYSegment.getLength() > 0.0f)) continue;
                    alignedBlock.addSegment(tempYSegment, false);
                }
            }
            List xSegBlock = alignedBlock.getSegments(true, true);
            List ySegBlock = alignedBlock.getSegments(false, true);
            alignedBlocks.add(alignedBlock.copy());
            alignedBlock.clear();
            int finishx = ((Segment)thisXBlock.get(thisXBlock.size() - 1)).getIndex();
            int finishy = ((Segment)thisYBlock.get(thisYBlock.size() - 1)).getIndex();
            xSegmentIndex = finishx + 1;
            if (xSegmentIndex <= maxhseg) {
                xSegment = (Segment)xAxisSegments.get(xSegmentIndex);
            }
            if ((ySegmentIndex = finishy + 1) > maxvseg) continue;
            ySegment = (Segment)yAxisSegments.get(ySegmentIndex);
        }
        return alignedBlocks;
    }

    public void backoffAlignment(List alignedBlocks) {
        for (int index = 0; index < alignedBlocks.size(); ++index) {
            double balanceScore;
            AlignedBlock currentAlignedBlock = (AlignedBlock)alignedBlocks.get(index);
            if (currentAlignedBlock.getBalanceStatus() == 0) continue;
            boolean mergePrevious = false;
            boolean mergeNext = false;
            if (index > 0) {
                AlignedBlock previousAlignedBlock = (AlignedBlock)alignedBlocks.get(index - 1);
                if (currentAlignedBlock.getBalanceStatus() == -1) {
                    if (previousAlignedBlock.hasSegments(true) && (balanceScore = currentAlignedBlock.computeBalance(previousAlignedBlock, false, false)) > Double.parseDouble(this.properties.getProperty(BACK_OFF))) {
                        mergePrevious = true;
                    }
                } else if (previousAlignedBlock.hasSegments(false) && (balanceScore = currentAlignedBlock.computeBalance(previousAlignedBlock, false, true)) > Double.parseDouble(this.properties.getProperty(BACK_OFF))) {
                    mergePrevious = true;
                }
            }
            if (index < alignedBlocks.size() - 1) {
                AlignedBlock nextAlignedBlock = (AlignedBlock)alignedBlocks.get(index + 1);
                if (currentAlignedBlock.getBalanceStatus() == -1) {
                    if (nextAlignedBlock.hasSegments(true) && (balanceScore = currentAlignedBlock.computeBalance(nextAlignedBlock, true, false)) > Double.parseDouble(this.properties.getProperty(BACK_OFF))) {
                        mergeNext = true;
                    }
                } else if (nextAlignedBlock.hasSegments(false) && (balanceScore = currentAlignedBlock.computeBalance(nextAlignedBlock, true, true)) > Double.parseDouble(this.properties.getProperty(BACK_OFF))) {
                    mergeNext = true;
                }
            }
            if (mergePrevious && mergeNext) {
                currentAlignedBlock.merge((AlignedBlock)alignedBlocks.get(index - 1));
                currentAlignedBlock.merge((AlignedBlock)alignedBlocks.get(index + 1));
                alignedBlocks.remove(index + 1);
                alignedBlocks.remove(index - 1);
                index -= 2;
                continue;
            }
            if (mergePrevious) {
                currentAlignedBlock.merge((AlignedBlock)alignedBlocks.get(index - 1));
                alignedBlocks.remove(index - 1);
                index -= 2;
                continue;
            }
            if (!mergeNext) continue;
            currentAlignedBlock.merge((AlignedBlock)alignedBlocks.get(index + 1));
            alignedBlocks.remove(index + 1);
            --index;
        }
    }

    public void gcAlign(List alignedBlocks) {
        for (int index = 0; index < alignedBlocks.size(); ++index) {
            AlignedBlock alignedBlock = (AlignedBlock)alignedBlocks.get(index);
            List xSegments = alignedBlock.getSegments(true, false);
            List ySegments = alignedBlock.getSegments(false, false);
            if (xSegments.size() <= 1 || ySegments.size() <= 1) continue;
            GCalign gcAlign = new GCalign();
            String[] params = new String[4];
            params[0] = "-d";
            params[1] = "<BRK>";
            params[2] = "-i";
            StringBuffer param = new StringBuffer();
            boolean isFirst = true;
            Iterator xSegmentIter = xSegments.iterator();
            while (xSegmentIter.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    param.append(",");
                }
                param.append(((Segment)xSegmentIter.next()).getDistance());
            }
            param.append(",").append(params[1]);
            Iterator ySegmentIter = ySegments.iterator();
            while (ySegmentIter.hasNext()) {
                param.append(",");
                param.append(((Segment)ySegmentIter.next()).getDistance());
            }
            params[3] = param.toString();
            List alignmentStrings = gcAlign.gcalign(params);
            int xStartIndex = 0;
            int yStartIndex = 0;
            Iterator alignmentIter = alignmentStrings.iterator();
            while (alignmentIter.hasNext()) {
                String alignmentString = (String)alignmentIter.next();
                StringTokenizer st = new StringTokenizer(alignmentString);
                int xSegmentNumber = Integer.parseInt(st.nextToken());
                st.nextToken();
                int ySegmentNumber = Integer.parseInt(st.nextToken());
                AlignedBlock newAlignedBlock = new AlignedBlock();
                for (int xIndex = xStartIndex; xIndex < xStartIndex + xSegmentNumber; ++xIndex) {
                    newAlignedBlock.addSegment((Segment)xSegments.get(xIndex), true);
                }
                for (int yIndex = yStartIndex; yIndex < yStartIndex + ySegmentNumber; ++yIndex) {
                    newAlignedBlock.addSegment((Segment)ySegments.get(yIndex), false);
                }
                alignedBlocks.add(index, newAlignedBlock);
                xStartIndex += xSegmentNumber;
                yStartIndex += ySegmentNumber;
                ++index;
            }
            alignedBlocks.remove(index);
            --index;
        }
    }

    public void printAlignedBlocks(List alignedBlocks) {
        Iterator iterator = alignedBlocks.iterator();
        String gsaOut = this.properties.getProperty("gsa.outputFile");
        if (gsaOut == null) {
            while (iterator.hasNext()) {
                System.err.println(((AlignedBlock)iterator.next()).toString());
            }
            return;
        }
        OutputFileHandler out = new OutputFileHandler(this.properties.getProperty("gsa.outputFile"));
        while (iterator.hasNext()) {
            out.write(((AlignedBlock)iterator.next()).toString() + "\n");
        }
        out.close();
    }

    public static void main(String[] args) {
        GSA gsa = new GSA(args);
        List alignedBlocks = gsa.generateAlignedBlocks();
        gsa.printAlignedBlocks(alignedBlocks);
        System.exit(0);
    }
}

