# Generated by default/object.tt
package Paws::NetworkFirewall::PerObjectStatus;
  use Moose;
  has SyncStatus => (is => 'ro', isa => 'Str');
  has UpdateToken => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::PerObjectStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::PerObjectStatus object:

  $service_obj->Method(Att1 => { SyncStatus => $value, ..., UpdateToken => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::PerObjectStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->SyncStatus

=head1 DESCRIPTION

Provides configuration status for a single policy or rule group that is
used for a firewall endpoint. Network Firewall provides each endpoint
with the rules that are configured in the firewall policy. Each time
you add a subnet or modify the associated firewall policy, Network
Firewall synchronizes the rules in the endpoint, so it can properly
filter network traffic. This is part of a SyncState for a firewall.

=head1 ATTRIBUTES


=head2 SyncStatus => Str

Indicates whether this object is in sync with the version indicated in
the update token.


=head2 UpdateToken => Str

The current version of the object that is either in sync or pending
synchronization.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

