package Google::Ads::AdWords::v201809::CustomAffinityToken;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %customAffinityId_of :ATTR(:get<customAffinityId>);
my %customAffinityTokenId_of :ATTR(:get<customAffinityTokenId>);
my %tokenType_of :ATTR(:get<tokenType>);
my %parameter_of :ATTR(:get<parameter>);

__PACKAGE__->_factory(
    [ qw(        customAffinityId
        customAffinityTokenId
        tokenType
        parameter

    ) ],
    {
        'customAffinityId' => \%customAffinityId_of,
        'customAffinityTokenId' => \%customAffinityTokenId_of,
        'tokenType' => \%tokenType_of,
        'parameter' => \%parameter_of,
    },
    {
        'customAffinityId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'customAffinityTokenId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'tokenType' => 'Google::Ads::AdWords::v201809::CustomAffinityToken::TokenType',
        'parameter' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'customAffinityId' => 'customAffinityId',
        'customAffinityTokenId' => 'customAffinityTokenId',
        'tokenType' => 'tokenType',
        'parameter' => 'parameter',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::CustomAffinityToken

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CustomAffinityToken from the namespace https://adwords.google.com/api/adwords/rm/v201809.

A token of custom affinity audience. A token can be a keyword or placement. It is immutable, that is, it can only be created or removed but not changed. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * customAffinityId


=item * customAffinityTokenId


=item * tokenType


=item * parameter




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

