# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153921;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"772353", "Novaya\ Shulba",
"771231", "Akkystau",
"771531", "Bulayevo",
"772435", "Zhanakorgan",
"771146", "Akzhaiksky\ District",
"771041", "Aktau\,\ Zhezkazgan",
"771144", "Kaztalovka",
"771039", "Priozersk",
"7847", "Republic\ of\ Kalmykia",
"7851", "Astrakhan",
"7862", "Sochi",
"7865", "Stavropol\ territory",
"7816", "Veliky\ Novgorod",
"771445", "Ubaganskoye",
"733", "Baikonur",
"7841", "Penza",
"771140", "Saikhin",
"77187", "Ekibastuz",
"77272956", "Talgar",
"772539", "Kazygurt",
"772239", "Makanchi",
"77149", "Kostanai",
"772541", "Myrzakent",
"771142", "Taipak",
"772437", "Zhosaly",
"772433", "Aralsk",
"77142", "Kostanai",
"771831", "Zhelezinka",
"77292", "Aktau",
"7485", "Yaroslavl",
"7482", "Tver",
"7472", "Belgorod",
"7475", "Tambov",
"772841", "Kapal",
"772138", "Gabidena\ Mustafina",
"7352", "Kurgan",
"772839", "Sarkand",
"7345", "Tyumen",
"7342", "Perm",
"772132", "Nurinsky\ District",
"771447", "Karabalyksky\ District",
"7813", "Leningrad\ region",
"771443", "Borovskoi",
"771649", "Zhaksynsky\ District",
"771631", "Shortandy",
"7820", "Cherepovets",
"772934", "Zhanaozen",
"7473", "Voronezh",
"7483", "Bryansk",
"772775", "Esik",
"771434", "Denisovka",
"771451", "Sarykol",
"7421", "Khabarovsk\ Territory",
"771436", "Taranovskoye",
"771430", "Arkalyk",
"7427", "Chukotka\ Autonomous\ District",
"7866", "Kabardino\-Balkarian\ Republic",
"7812", "St\ Petersburg",
"7815", "Murmansk",
"771135", "Zhanibek",
"772639", "Saudakent",
"7353", "Orenburg",
"77279", "Almaty",
"772641", "Akkol",
"7343", "Ekaterinburg",
"772938", "Fort\ Shevchenko",
"7395", "Irkutsk",
"77272", "Almaty",
"772147", "Egindybulak",
"7486", "Orel",
"772932", "Beineu",
"772773", "Bakanas",
"771438", "Amangeldy",
"771331", "Martuk",
"771349", "Shalkarsky\ District",
"772257", "Shulbinsk",
"772777", "Kegen",
"7346", "Surgut",
"77245", "Kyzylorda\ Region",
"772341", "Ulken\ Naryn",
"772339", "Kurchum",
"7818", "Arkhangelsk",
"771133", "Aksai",
"7863", "Rostov",
"77212", "Karaganda",
"771137", "Chingirlau",
"771646", "Makinsk",
"7817", "Vologda",
"772545", "Ikan",
"772843", "Lepsy",
"771342", "Badamsha",
"771644", "Arshaly",
"7384", "Kemerovo",
"77135", "Aktobe\ Region",
"771441", "Karabalyk",
"7834", "Republic\ of\ Mordovia",
"771348", "Shalkarsky\ District",
"77272983", "Kaskelen",
"7869", "Sevastopol",
"771439", "Torgai",
"772431", "Zhalagash",
"772338", "Bozanbai\/Molodezhnyi",
"771535", "Novoishimski",
"772636", "Kordai",
"7811", "Pskov",
"771235", "Dossor",
"771833", "Terenkol",
"77282", "Taldykorgan",
"771640", "Balkashino",
"7846", "Samara",
"772332", "Shemonaikha",
"771837", "Aksu",
"772634", "Zhanatas",
"771648", "Derzhavinsk",
"772153", "Topar",
"77102", "Zhezkazgan",
"772547", "Lenger",
"771642", "Egendykol",
"772330", "Zyryanovsky\ District",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"772543", "Aqsumbe",
"7717", "Astana",
"7391", "Krasnoyarsk\ Territory",
"771346", "Shubarkuduk",
"771237", "Kulsary",
"772334", "Tavricheskoye",
"771537", "Timiryazevo",
"7843", "Republic\ of\ Tatarstan",
"772632", "Merke",
"771340", "Khobdinsky\ District",
"772351", "Borodulikha",
"77252", "Shymkent",
"771233", "Ganyushkino",
"771533", "Saumalkol",
"77222", "Semey",
"772336", "Ridder",
"772757", "Akshi",
"772638", "Tole\ bi",
"771043", "Zhairem",
"772530", "Temirlanovka",
"771842", "Koktobe",
"772230", "Urdzhar",
"772347", "Kalbatau",
"771544", "Presnovka",
"771546", "Talshik",
"7867", "Republic\ of\ North\ Ossetia",
"7426", "Jewish\ Autonomous\ Region",
"772343", "Terekty",
"771034", "Zhezdy",
"771131", "Darinskoye",
"7494", "Kostroma",
"771149", "Zelenovsky\ District",
"771036", "Balkhash",
"77185", "Shaldai",
"772838", "Balpyk\ bi",
"771030", "Atasu",
"771455", "Zatobolsk",
"772251", "Kurchatov",
"771540", "Kishkenekol",
"7845", "Saratov",
"772832", "Zhansugurov",
"7842", "Ulyanovsk",
"772771", "Kaskelen",
"772534", "Zhetysai",
"771337", "Alga",
"771635", "Zhaksy",
"772536", "Kentau",
"772236", "Beskaragai",
"77232", "Ust\-Kamenogorsk",
"7861", "Krasnodar\ Territory",
"771333", "Kandyagash",
"7855", "Naberezhnye\ Chelny",
"7471", "Kursk",
"77125", "Atyrau\ Region",
"7347", "Republic\ of\ Bashkortostan",
"7481", "Smolensk",
"771032", "Karazhal",
"77273", "Almaty",
"772643", "Shu",
"7423", "Primorie\ territory",
"772345", "Shar",
"771844", "Irtyshsky\ District",
"771038", "Shashubai",
"771542", "Kishkenekol",
"772830", "Alakolsky\ District",
"77262", "Taraz",
"771633", "Ereimentau",
"77213", "Aktau\/Temirtau",
"771335", "Shalkar",
"772836", "Karabulak",
"772834", "Ushtobe",
"771637", "Korgalzhyn",
"772532", "Abai",
"771840", "Bayanaul",
"7848", "Tolyatti",
"771453", "Auliekol",
"7341", "Udmurtian\ Republic",
"7487", "Tula",
"771457", "Dzhangildinsky\ District",
"7351", "Chelyabinsk",
"772538", "Turara\ Ryskulova",
"772146", "Karkaralinsk",
"771435", "Zhitikara",
"771130", "Peremetnoye",
"772159", "Karaganda\ Region",
"772144", "Kiyevka",
"772256", "Kainar",
"772776", "Shelek",
"772531", "Aksukent",
"772935", "Zhetybai",
"772774", "Talgar",
"736", "Simferopol",
"771541", "Mamlutka",
"7835", "Chuvashi\ Republic",
"772770", "Uzynagash",
"7496", "Moscow",
"771239", "Makat",
"771539", "Beskol",
"771136", "Chapayev",
"7424", "Sakhalin\ Region",
"7382", "Tomsk",
"772759", "Almaty\ Region",
"771134", "Zhympity",
"7385", "Altai\ Territory",
"771031", "Aksu\-Ayuly",
"772252", "Karaul",
"772772", "Kapchagai",
"772148", "Molodezhnoye",
"772831", "Zharkent",
"772937", "Kuryk",
"7877", "Republic\ of\ Adygeya",
"771437", "Kamysty",
"772778", "Chundzha",
"77224", "Barshatas",
"77242", "Kyzylorda",
"771433", "Lisakovsk",
"7388", "Republic\ of\ Altai",
"771132", "Fyodorovka",
"771839", "Akku",
"771138", "Zhalpaktal",
"771841", "Aktogai",
"7871", "Chechen\ Republic",
"771440", "Amangeldy",
"7844", "Volgograd",
"7301", "Republic\ of\ Buryatia",
"771145", "Karatobe\ District",
"772436", "Terenozek",
"7411", "Republic\ of\ Sakha",
"772631", "Kulan",
"740", "Kaliningrad",
"771641", "Astrakhanka",
"7836", "Republic\ of\ Marij\ El",
"7495", "Moscow",
"7492", "Vladimir",
"771639", "Stepnyak",
"7712303", "Tengizs",
"771459", "Kostanai\ Region",
"771444", "Uzunkol",
"771446", "Uzunkolsky\ District",
"77106", "Satpaev",
"772331", "Glubokoye",
"772438", "Aiteke\ bi",
"771143", "Akzhaik",
"771147", "Akzhaiksky\ District",
"7879", "Mineranye\ Vody",
"772432", "Shiyeli",
"77112", "Uralsk",
"7383", "Novosibirsk",
"772137", "Saran",
"771442", "Fyodorovka",
"7390", "Republic\ of\ Khakassia",
"77145834", "Krasnogorsk",
"7498", "Moscow",
"771339", "Komsomolskoye",
"771341", "Khobda",
"7833", "Kirov",
"771448", "Oktyabrskoye",
"771035", "Ulytau",
"772439", "Aralsky\ District",
"772348", "Kokpekty",
"7415", "Kamchatka\ Region",
"771843", "Maisky\ District",
"771545", "Zhambylsky\ District",
"772644", "Karatau",
"771630", "Burabay",
"772342", "Katon\-Karagai",
"7302", "Chita",
"77182", "Pavlodar",
"772833", "Usharal",
"772931", "Shetpe",
"7821", "Komi\ Republic",
"771636", "Shuchinsk",
"772535", "Shardara",
"772837", "Kabanbai",
"771651", "Kabanbai\ Batyr",
"7712302", "Tengizshevroil",
"772640", "Moiynkumsky\ District",
"771332", "Uil",
"771456", "Kachar",
"7873", "Ingushi\ Republic",
"771449", "Taranovskoye",
"771454", "Karamendy",
"7491", "Ryazan",
"771431", "Rudny",
"772642", "Moiynkum",
"771330", "Khromtau\ District",
"771547", "Zhambylsky\ District",
"772344", "Akzhar",
"771845", "Pavlodar\ Area",
"772346", "Aksuat",
"771543", "Yavlenka",
"771037", "Aktogai",
"771033", "Agadyr",
"771452", "Karasu",
"771638", "Akkol",
"7484", "Kaluga",
"7474", "Lipetsk",
"771458", "Kostanai\ Region",
"771632", "Zerenda",
"772340", "Zaisan",
"771334", "Emba",
"772537", "Saryagash",
"772237", "Ayagoz",
"772835", "Tekeli",
"771336", "Khromtau",
"77122", "Atyrau",
"772533", "Turkestan",
"77152", "Petropavlovsk",
"771040", "Zhairem\ \(GOK\)",
"772149", "Osakarovka",
"772154", "Botakara",
"772131", "Abai",
"772156", "Shakhtinsk",
"772544", "Shaulder",
"771347", "Aitekebisky\ District",
"772779", "Narynkol",
"772842", "Kogaly",
"771230", "Atyrau\ Region",
"771343", "Irgiz",
"7499", "Moscow",
"7416", "Amur\ Region",
"772725", "Otegen\ Batyra",
"7814", "Republic\ of\ Karelia",
"771645", "Stepnogorsk",
"772546", "Sholakkorgan",
"7381", "Omsk",
"772337", "Serebryansk",
"771534", "Sergeyevka",
"771234", "Indernborski",
"771832", "Irtyshsk",
"772540", "Arys",
"772333", "Samarskoye",
"77132", "Aktobe\/Kargalinskoye",
"771236", "Makhambet",
"771536", "Taiynsha",
"772635", "Bauyrzhan\ Mamyshuly",
"771139", "Taskala",
"7831", "Nizhni\ Novgorod",
"771141", "Zhangala",
"771838", "Koktobe",
"7878", "Karachayevo\-Cherkessian\ Republic",
"771345", "Karauylkeldy",
"7413", "Magadan",
"771643", "Atbasar",
"772542", "Asykata",
"771647", "Esil",
"772548", "Shayan",
"7872", "Republic\ of\ Daghestan",
"772752", "Otegen\ Batyra",
"771538", "Beskol",
"771238", "Miyaly",
"771042", "Zharyk",
"771836", "Sharbakty",
"772335", "Zyryanovsk",
"7394", "Republic\ of\ Tuva",
"77274", "Karassaisky\ District",
"772633", "Asa",
"77162", "Kokshetau\/Krasni\ Yar",
"772840", "Saryozek",
"771232", "Atyrau\ Region",
"771532", "Smirnovo",
"772637", "Sarykemer",
"771834", "Uspenka",};
$areanames{ru} = {"771541", "Мамлютский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"772770", "Жамбылский\ р\-н",
"7496", "г\.\ Москва",
"771239", "Макатский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"736", "Республика\ Крым",
"772759", "Алматинская\ область",
"7382", "Томская\ обл\.",
"771031", "Шетский\ р\-н",
"7385", "Алтайский\ край",
"771134", "Сырымский\ р\-н",
"771136", "Акжаикский\ р\-н",
"7424", "Сахалинская\ обл\.",
"771130", "Зеленовский\ р\-н",
"772159", "Карагандинская\ область",
"772144", "Нуринский\ р\-н",
"771435", "Житикаринский\ р\-н",
"772146", "Каркаралинск",
"772531", "Аксукент",
"772935", "Каракиянский\ р\-н",
"772774", "Талгарский\ р\-н",
"772256", "Алгабас",
"772776", "Енбекшиказахский\ р\-н",
"7388", "Республика\ Алтай",
"771132", "Теректинский\ р\-н",
"7871", "Республика\ Чеченская",
"7493", "Ивановская\ обл\.",
"771839", "Лебяжинский\ р\-н",
"771841", "Актогайский\ р\-н",
"771138", "Казталовский\ р\-н",
"772937", "Каракиянский\ р\-н",
"7877", "Республика\ Адыгея",
"772252", "Абайский\ р\-н",
"772831", "Панфиловский\ р\-н",
"772148", "Осакаровский\ р\-н",
"772772", "Капчагай",
"77242", "Кызылорда",
"77224", "Эмельтау",
"771433", "Лисаковск",
"771437", "Камыстинский\ р\-н",
"772778", "Уйгурский\ р\-н",
"7712303", "Тензиз",
"740", "Калининградская\ обл\.",
"771641", "Астраханский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"7495", "Московская\ обл\.",
"771639", "Енбекшилдерский\ р\-н",
"7492", "Владимирская\ обл\.",
"771446", "Узункольский\ р\-н",
"77106", "Сатпаев",
"771459", "Костанайская\ область",
"771444", "Узункольский\ р\-н",
"772436", "Сырдарьинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"7844", "Волгоградская\ обл\.",
"771440", "Амангельдинский\ р\-н",
"7301", "Республика\ Бурятия",
"772631", "Турара\ Рыскулова\ р\-н",
"772137", "Сарань",
"7383", "Новосибирская\ обл\.",
"771442", "Федоровский\ р\-н",
"77112", "Уральск",
"77145834", "Красногорск",
"7498", "Московская\ обл\.",
"771339", "Айтекебийский\ р\-н",
"771341", "Хобдинский\ р\-н",
"771448", "Карасуский\ р\-н",
"7833", "Кировская\ обл\.",
"7390", "Республика\ Хакасия",
"772331", "Глубоковский\ р\-н",
"772438", "Казалинский\ р\-н",
"771147", "Акжаикский\ р\-н",
"7879", "Ставропольский\ край",
"772432", "Шиелийский\ р\-н",
"771143", "Теректинский\ р\-н",
"772837", "Алакольский\ р\-н",
"7712302", "Тенгизшевройл",
"771651", "Целиноградский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"771332", "Уилский\ р\-н",
"77182", "Павлодар",
"772833", "Алакольский\ р\-н",
"772931", "Мангистауский\ р\-н",
"771636", "Щучинский\ р\-н",
"772535", "Шардара",
"7821", "Республика\ Коми",
"771449", "Тарановский\ р\-н",
"7491", "Рязанская\ обл\.",
"771454", "Наурзумский\ р\-н",
"771431", "Рудный",
"771456", "Качар",
"7873", "Республика\ Ингушетия",
"772439", "Аральский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"771035", "Улытауский\ р\-н",
"772644", "Таласский\ р\-н",
"7302", "Забайкальский\ край",
"772342", "Катон\-Карагайский\ р\-н",
"771630", "Боровое",
"7415", "Камчатский\ край",
"771843", "Майский\ р\-н",
"771545", "Жамбылский\ р\-н",
"7484", "Калужская\ обл\.",
"7474", "Липецкая\ обл\.",
"771638", "Аккольский\ р\-н",
"771452", "Карасуский\ р\-н",
"772835", "Текели",
"771336", "Хромтауский\ р\-н",
"772533", "Туркестан",
"77122", "Атырау",
"77152", "Петропавловск",
"772340", "Зайсанский\ р\-н",
"771632", "Зерендинский\ р\-н",
"771458", "Костанайская\ область",
"771334", "Мугалжарский\ р\-н",
"772537", "Сарыагаш",
"772237", "Аязог",
"771845", "Павлодар",
"772346", "Тарбагатайский\ р\-н",
"771543", "Есильский\ р\-н",
"771330", "Хромтауский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"771033", "Шетский\ р\-н",
"771037", "Актогайский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"77132", "Актобе\/Актюбинск",
"771236", "Махамбетский\ р\-н",
"772635", "Жуалынский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"772337", "Серебрянск",
"771534", "Шал\ Акына\ р\-н",
"7381", "Омская\ обл\.",
"771234", "Индерский\ р\-н",
"771832", "Иртышский\ р\-н",
"772540", "Арыс",
"7878", "Республика\ Карачаево\-Черкесская",
"771139", "Таскалинский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771838", "Майский\ р\-он",
"771141", "Жангалинский\ р\-н",
"772156", "Шахтинск",
"772149", "Осакаровский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"772154", "Бухар\-Жырауский\ р\-н",
"772131", "Абайский\ р\-н",
"7499", "г\.\ Москва",
"7416", "Амурская\ обл\.",
"771343", "Иргизский\ р\-н",
"772725", "Отеген\-Батыр",
"772546", "Шолаккорган",
"7814", "Республика\ Карелия",
"771645", "Степногорск",
"772544", "Шаульдер",
"771347", "Айтекебийский\ р\-н",
"772779", "Райымбекский\ р\-н",
"772842", "Кербулакский\ р\-н",
"771230", "Атырауская\ область",
"771538", "Кызылжарский\ р\-н",
"772752", "Илийский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"771042", "Акой",
"7872", "Республика\ Дагестан",
"771232", "Атырауская\ область",
"772840", "Кербулакский\ р\-н",
"771532", "Аккайынский\ р\-н",
"772637", "Байзакский\ р\-н",
"771834", "Успенский\ р\-н",
"771836", "Щербактинский\ р\-н",
"7394", "Республика\ Тыва",
"772335", "Зыряновск",
"77274", "Карасайский\ р\-н",
"772633", "Жамбылский\ р\-н",
"77162", "Кокшетау",
"772542", "Асыката",
"771647", "Есильский\ р\-н",
"771345", "Байганинский\ р\-н",
"771643", "Атбасарский\ р\-н",
"7413", "Магаданская\ обл\.",
"772548", "Шаян",
"733", "Байконыр",
"7841", "Пензенская\ обл\.",
"771140", "Бокейординский\ р\-н",
"7862", "Краснодарский\ край",
"7851", "Астраханская\ обл\.",
"7865", "Ставропольский\ край",
"7816", "Новгородская\ обл\.",
"771445", "Алтынсаринский\ р\-н",
"772539", "Казыгурт",
"772239", "Урджарский\ р\-н",
"77149", "Костанай",
"772541", "Мырзакент",
"77187", "Экибастуз",
"77272956", "Талгар",
"771231", "Исатайский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"772353", "Бородулихинский\ р\-н",
"771144", "Казталовский\ р\-н",
"771041", "Актау\,\ Жезказган",
"7847", "Республика\ Калмыкия",
"771039", "Приозерск",
"771146", "Акжаикский\ р\-н",
"772435", "Жанакорганский\ р\-н",
"7345", "Тюменская\ обл\.",
"7342", "Пермский\ край",
"772138", "Бухар\-Жырауский\ р\-н",
"772841", "Аксуский\ р\-н",
"7352", "Курганская\ обл\.",
"772839", "Саркандский\ р\-н",
"7813", "Ленинградская\ обл\.",
"771443", "Мендыкаринский\ р\-н",
"772132", "Нуринский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"772433", "Аральский\ р\-н",
"77142", "Костанай",
"771142", "Акжаикский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"7485", "Ярославская\ обл\.",
"7482", "Тверская\ обл\.",
"7472", "Белгородская\ обл\.",
"7475", "Тамбовская\ обл\.",
"771831", "Железинский\ р\-н",
"77292", "Актау",
"7427", "Чукотский\ АО",
"7866", "Республика\ Кабардино\-Балкарская",
"7812", "г\.\ Санкт\-Петербург",
"771135", "Жанибекский\ р\-н",
"7815", "Мурманская\ обл\.",
"771430", "Аркалык",
"7343", "Свердловская\ обл",
"772639", "Сарысуский\ р\-н",
"7353", "Оренбургская\ обл\.",
"77279", "Алматы",
"772641", "Таласский\ р\-н",
"7820", "Вологодская\ обл\.",
"7473", "Воронежская\ обл\.",
"772934", "Жанаозен",
"772775", "Енбекшиказахский\ р\-н",
"7483", "Брянская\ обл\.",
"771649", "Жаксынский\ р\-н",
"771631", "Шортандинский\ р\-н",
"7421", "Хабаровский\ край",
"771436", "Тарановский\ р\-н",
"771434", "Денисовский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"772339", "Курчумский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"77245", "Кызылординская\ область",
"771137", "Чингирлауский\ р\-н",
"7818", "Архангельская\ обл\.",
"771133", "Бурлинский\ р\-н",
"77212", "Караганда",
"7863", "Ростовская\ обл\.",
"772147", "Каркаралинский\ р\-н",
"7395", "Иркутская\ обл\.",
"772938", "Тупкараганский\ р\-н",
"77272", "Алма\-Ата",
"771438", "Амангельдинский\ р\-н",
"771331", "Мартукский\ р\-н",
"772257", "Шульбинск",
"771349", "Шалкарский\ р\-н",
"772777", "Райымбекский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"7486", "Орловская\ обл\.",
"772773", "Балхашский\ р\-н",
"772431", "Жалагашский\ р\-н",
"772338", "Уланский\ р\-н",
"7846", "Самарская\ обл\.",
"772332", "Шемонаихинский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"771837", "Аксуский\ р\-н",
"772634", "Жанатас",
"7811", "Псковская\ обл\.",
"771535", "Габита\ Мусрепова\ р\-н",
"772636", "Кордай",
"771235", "Макатский\ р\-н",
"771833", "Качирский\ р\-н",
"77282", "Талдыкорган",
"771342", "Каргалинский\ р\-н",
"771644", "Аршалынский\ р\-н",
"7384", "Кемеровская\ обл\.",
"7817", "Вологодская\ обл\.",
"771646", "Буландинский\ р\-н",
"772545", "Икан",
"772843", "Лепсы",
"771441", "Карабалыкский\ р\-н",
"771348", "Шалкарский\ р\-н",
"7834", "Республика\ Мордовия",
"77272983", "Каскелен",
"771439", "Джангильдинский\ р\-н",
"7869", "г\.\ Севастополь",
"77135", "Актюбинская\ область",
"771233", "Курмангазинский\ р\-н",
"77252", "Шымкент",
"77222", "Семипалатинск",
"771533", "Айыртауский\ р\-н",
"772336", "Риддер",
"771237", "Жылыойский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"772334", "Уланский\ р\-н",
"7843", "Республика\ Татарстан",
"771340", "Хобдинский\ р\-н",
"772632", "Меркенский\ р\-н",
"772351", "Бородулихинский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"772757", "Акший",
"772638", "Шуский\ р\-н",
"772153", "Абайский\ р\-н",
"77102", "Жезказган",
"771648", "Жаркаинский\ р\-н",
"7717", "Астана",
"772543", "Аксумбе",
"7391", "Красноярский\ край",
"771346", "Темирский\ р\-н",
"772547", "Ленгер",
"7349", "Ямало\-Ненецкий\ АО",
"772330", "Зыряновский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771455", "Костанайский\ р\-н",
"772838", "Коксуский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"772536", "Кентау",
"771635", "Жаксынский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"7861", "Краснодарский\ край",
"77232", "Усть\-Каменогорск",
"7855", "Республика\ Татарстан",
"771333", "Мугалжарский\ р\-н",
"7845", "Саратовская\ обл\.",
"771540", "Уалихановский\ р\-н",
"772251", "Курчатов",
"772771", "Карасайский\ р\-н",
"7842", "Ульяновская\ обл\.",
"772832", "Аксуский\ р\-н",
"771337", "Алгинский\ р\-н",
"772534", "Жетысай",
"771546", "Акжарский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"772343", "Курчумский\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"772530", "Темирлановка",
"771842", "Майский\ р\-он",
"772230", "Урджарский\ р\-н",
"772347", "Жарминский\ р\-н",
"771544", "Жамбылский\ р\-н",
"77185", "Шалдай",
"771036", "Балхаш",
"771131", "Зеленовский\ р\-н",
"771034", "Улытауский\ р\-н",
"7494", "Костромская\ обл\.",
"771149", "Акжаикский\ р\-н",
"772834", "Каратальский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"772532", "Абая",
"7848", "Самарская\ обл\.",
"771840", "Баянаульский\ р\-н",
"77262", "Тараз",
"77213", "Темиртау",
"771633", "Ерейментауский\ р\-н",
"771335", "Шалкарский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"7351", "Челябинская\ обл\.",
"771457", "Джангильдинский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"771453", "Аулиекольский\ р\-н",
"7487", "Тульская\ обл\.",
"7341", "Республика\ Удмуртская",
"771032", "Каражал",
"7471", "Курская\ обл\.",
"77125", "Атырауская\ область",
"7347", "Республика\ Башкортостан",
"7481", "Смоленская\ обл\.",
"771844", "Иртышский\ р\-н",
"771038", "Сыры\-Шаган",
"771542", "Уалихановский\ р\-н",
"772830", "Алакольский\ р\-н",
"7423", "Приморский\ край",
"77273", "Алма\-Ата",
"772643", "Шуский\ р\-н",
"772345", "Жарминский\ р\-н",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;