package Catalyst::Helper::Controller::Atompub::Collection;

use strict;
use warnings;

sub mk_compclass {
    my($self, $helper) = @_;
    $helper->render_file('compclass', $helper->{file});
}

1;

=head1 NAME

Catalyst::Helper::Controller::Atompub::Collection - Helper for Atom Collection Resources

=head1 SYNOPSIS

    $ perl script/myapp_create.pl controller MyCollection Atompub::Collection

=head1 DESCRIPTION

Helper for the L<Catalyst> Atom Collection Resources.
See L<Catalyst::Controller::Atompub::Collection>.

=head1 METHODS

=head2 mk_compclass

Makes the Atom Collection Resources class.

=head1 SEE ALSO

L<Catalyst::Controller::Atompub::Collection>

=head1 AUTHOR

Takeru INOUE, E<lt>takeru.inoue _ gmail.comE<gt>

=head1 LICENCE AND COPYRIGHT

Copyright (c) 2007, Takeru INOUE C<< <takeru.inoue _ gmail.com> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

=cut

__DATA__

=begin pod_to_ignore

__compclass__
package [% class %];

use strict;
use warnings;
use base qw(Catalyst::Controller::Atompub::Collection);

# Call auto() of superclass if defining auto() in this class
#use Next;
#sub auto :Private {
#    my($self, $c) = @_;
#    $self->NEXT::auto($c);
#}

# List resources in a Feed Document
sub get_feed :Atompub(list) {
    my($self, $c) = @_;

    # Skeleton of the Feed (XML::Atom::Feed) was prepared by C::C::Atompub
    my $feed = $self->collection_resource->body;

    # Add entries into $feed...

    return 1;
}

# Create the new Resource
sub create_resource :Atompub(create) {
    my($self, $c) = @_;

    # Create the Resource in your Model...

    return 1;
}

# Search the requested Resource
sub get_resource :Atompub(read) {
    my($self, $c) = @_;

    # Retrieve the Resource...

    return 1;
}

# Update the requested Resource
sub update_entry :Atompub(update) {
    my($self, $c) = @_;

    # Update the Resource...

    return 1;
}

# Delete the requested Resource
sub delete_entry :Atompub(delete) {
    my($self, $c) = @_;

    # Delete the Resource...

    return 1;
}

# Make EditURI by yourself (it will be automatically generated by default)
#sub make_edit_uri {
#    my($self, $c, @args) = @_;
#}

# Find version information of the Resource for caching and versioning
#sub find_version {
#    my($self, $c, $uri) = @_;
#}

=head1 NAME

[% class %] - Atom Collection Resources

=head1 SYNOPSIS

See L<[% app %]>.

=head1 DESCRIPTION

Atom Collection Resources class.

=head1 AUTHOR

[% author %]

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
