:: REQUIRES NET Framework v2.0+
:: [VISTA (and later) should always have v2.0+ installed]
@echo off
setlocal

::convert all non-switch/non-option arguments into build targets
::NOTE: using the default '.proj' MSBuild project file (so, no need to specify project file name on command line, only targets)
set args=
set line=%*
:gatherargs
for /f "tokens=1,*" %%a in ("%line%") do (
	set "arg=%%a"
	set "line=%%b"
	)
if [%arg%] == [] ( goto :gatherargs_next )
if NOT [%arg:~0,1%] == [/] ( set arg=/t:%arg% )
:gatherargs_next
set args=%args% %arg%
if NOT [%line%]==[] ( goto :gatherargs )

:: MSBuild_v [default to v2.0 {shipped with Vista}]
if [%MSBuild_v%]==[] set MSBuild_v="2.0"

:: Find SDK tool path(s) in the registry
if NOT 01 == 1.0 (
	for /f "skip=2 tokens=2*" %%A in (
	    '"reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSBuild\ToolsVersions\%MSBuild_v%" /v MSBuildToolsPath 2> nul"'
	    ) do set MSBuildPATH=%%B
	) else (
	:: 4NT/TCC/TCMD
	set MSBuildPATH=%@regquery["HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSBuild\ToolsVersions\%MSBuild_v%\MSBuildToolsPath"]
	if [%MSBuildPATH%]==[-1] set "MSBuildPATH="
	)
::if [%MSBuildPATH%]==[] (goto :notfound) else (goto :build)
if [%MSBuildPATH%]==[] ( set "MSBuildPATH=C:\WINDOWS\Microsoft.NET\Framework\v2.0.50727" )
if NOT EXIST "%MSBuildPATH%/MSBuild.EXE" (goto :notfound) else (goto :build)

:build
:: NOTES:
::/consoleloggerparameters:<parameters>
::                   Parameters to console logger. (Short form: /clp)
::                   The available parameters are:
::                      PerformanceSummary--Show time spent in tasks, targets and projects.
::                      Summary--Show error and warning summary at the end.
::                      NoSummary--Don't show error and warning summary at the end.
::                      ErrorsOnly--Show only errors.
::                      WarningsOnly--Show only warnings.
::                      NoItemAndPropertyList--Don't show list of items and properties at the start of each project build.
::                      ShowCommandLine--Show TaskCommandLineEvent messages
::						ShowTimestamp--Display the Timestamp as a prefix to any message.
::                      ShowEventId--Show eventId for started events, finished events, and messages
::                      ForceNoAlign--Does not align the text to the size of the console buffer
::                      DisableMPLogging-- Disable the multiprocessor logging style of output when running in non-multiprocessor mode.
::                      EnableMPLogging--Enable the multiprocessor logging style even when running in non-multiprocessor mode. This logging style is on by default.
::                      Verbosity--overrides the /verbosity setting for this logger.
::                   Example:
::                      /consoleloggerparameters:PerformanceSummary;NoSummary;Verbosity=minimal
:: /nologo = prevent MS logo display
::"%MSBuildPATH%/MSBuild.EXE" /nologo /clp:ShowTimestamp;NoItemAndPropertyList %*
::"%MSBuildPATH%/MSBuild.EXE" /nologo /consoleloggerparameters:PerformanceSummary;NoSummary;Verbosity=diagnostic %*
"%MSBuildPATH%/MSBuild.EXE" /nologo %args%
::if not errorlevel 0 (exit /b 1) else (exit /b 0)
goto :EOF

:notfound
echo MSBuild: cannot find MSBuild location in the registry
echo Checked %MSBuildPATH%
exit /b 1
