use strict;
use warnings;
use utf8;
use constant SENTENCES => (
	q{מטרתו של טקסט זה היא לשמש כעזר לבדיקת התוכנה לחלוקת טקסט עברי למשפטים אשר כתבתי.},
	q{לטקסט זה נלווה טקסט נוסף, מקביל ובו החלוקה למשפטים כבר מוכנה.},
	q{בהמשך, ארשום סוגים שונים של משפטים אשר אני מקווה שיסווגו נכונה ע"י התוכנה.},
	q{"מה כבר ניתן לבדוק?"},
	q{וודאי תשאלו...},
	q{ובכן, נראה כי כל מופע של נקודה (.), סימן שאלה (?) וסימן קריאה (!) מהווים סימן חד-משמעי לסוף משפט.},
	q{ובכן, לא כך בפועל.},
	q{למעשה, סימנים אלה משמשים גם במקומות אחרים, למשל קיצורים שונים השאולי מאנגלית (לדוגמה, השם  'י.ב.מ.' היה, למעשה צריך כנראה להכתב בעברית כ-'יב"מ', אך מעטים אכן כותבים כך).},
	q{עוד יוצאים מהכלל הם שילובים של סימנים אלה כגון: שלוש נקודות '...', סימן לתמיהה או הפתעה '?!' וכיוצא באלה.},
	q{מקרים נוספים אשר מסמלים כנראה סוף משפט הם מקרים של יותר מתו אחד של שורה חדשה.},
	q{הנה, טקסט לדוגמה מתוך מכתב לדיירי בניין מאת יו"ר ועד הדיירים:},
	q{לגיא ולכל הדיירים שלום,},
	q{--- תחילת הטקסט ---},
	q{עפ"י חוות דעת של האגודה לתרבות הדיור – ניתן לכפות החלטת רוב רק על נושאים הקשורים לתחזוקתו התקינה של הבניין.},
	q{מכיוון שנושא חדר הכושר לא נופל בקטגוריה זו הרי שעל מנת לצאת לדרך צריכים לפעול עפ"י המלצת הוועד (מפגישתנו המשותפת עם חברי הוועדה ובנוכחות אבי ומיקי) ולהפעיל את החדר בשלבים – עפ"י יכולתנו הכספיות.},
	q{יכול אמנם להיות שזה בניגוד להמלצתם של חלק מחברי הוועדה שבדקה את הנושא אבל בסופו של דבר הוועד הוא המוציא לפועל וההיגיון אומר – הפעלת חדר הכושר בשלבים.},
	q{בשלב זה קל יותר להקים תשתית בסיסית שיכולה לכלול: מזגן, סורגים, מזרנים ושולחן פינג-פונג – כל זאת תוך גיוס של לא יותר מ300 ₪ מכל דייר.},
	q{תשתית בסיסית מעין זו תשמש את כל הדיירים ללא יצירת קליקות או קבוצות.},
	q{התשתית תשמש גם את אלו שרוצים להתעמל, גם לחוגי יוגה או בריאות, גם לילדים וגם סתם כיף של להתגלגל יחד בחדר....},
	q{התשתית תשרת את כלל האוכלוסייה בבניין.},
	q{לפיכך, ההיגיון אומר שיהיה קל יחסית להעביר החלטה על גיוס של 300 ש"ח – כפי שהדבר מסתמן גם בטפסים/שאלונים שאני מקבל חזרה מהדיירים.},
	q{לעומת זאת, ההחלטה לגבי רכישת ציוד כושר מהווה למעלה מ 30% מתקציב ההשקעות הכולל (660 מתוך 1785) ומדובר בסכום משמעותי ביותר.},
	q{בעיקר, השקעה זו אינה משרתת את כל הדיירים אלא רק חלק מהם ולכן נדרשת עבורה התייחסות שונה – הן עקב משקלה הסגולי הגבוה בסל ההשקעות והן עקב חילוקי הדעות לגביה (שהם חדים יותר מאשר בכל נושא אחר).},
	q{ההמלצות בעד ונגד משקפות את דעתם של רבים מהדיירים עימם שוחחנו והתכתבנו, ולכן מצאנו לנכון להביא את רוח הדברים והנימוקים בפני הדיירים.},
	q{(גם קיומם של ימי הולדת לא תתאפשר בשלב ראשון עקב מורכבות הנושא וחילוקי הדעות הקיימים סביבו).},
	q{יחד עם זאת, הדיירים אמרו את דברם והרוב אמנם מעוניין בחדר כושר.},
	q{ולכן ניתן לצפות שהרוב גם ירתם לגיוס כספים עבור מכשירים ברוח העדפותיו אלו.},
	q{לפיכך אמונתי היא שאותם דיירים שהצביעו בעד חדר הכושר יצביעו גם בעד גיוס כסף לרכישת הציוד – ויעשו כן בעדיפות גבוהה ואז נוכל לממן לפחות חלק מהציוד.},
	q{בכל מקרה, כוונתנו היא להפעיל את חדר הכושר עוד במהלך חופשת הקיץ.},
	q{שלכם,},
	q{חנוך},
	q{--- סוף הטקסט ---},
	q{עוד כמה מקרים: מה זה?!},
	q{אויש...},
	q{סי.פי.אס. לא מבינים.},
	q{וייי.},
	q{"בניגוד לאותן אבנים הרודיאניות מפורסמות בירושלים, היא גם ידעה לענות.},
	q{מה שבא ללמדך, שלו גברים היו חשים את סוד האשה, והן מצדן היו יותר רחומות, לא היתה אומללות גברית רבה כל-כך מוטחת לשווא בקיר אבנים..."},
	q{קטע מתוך "על שלושה גשרים" מאת יונתן פיין, שפותח סדרת מקור חדשה בהוצאת "כרמל".},
	q{"לא אגזים אם אומר כי מבחינה פיננסית, בתקופתו של גברי עלינו לרמה אחרת לחלוטין ממה שהכרנו לפניו", העיד אבן עזרא בבית המשפט.},
	q{"את המקרה הנוכחי (הכאת העיתונאי - מ.ג) אני מכיר דרך העיתונות ואני רוצה לומר שאולי זה קרה יותר במסגרת הרגשות.},
	q{גברי מעולם לא היה חבר קרוב שלי, עבדנו צמוד וביחד, אבל למדתי לאהוב אותו.},
	q{לפעמים הייתי נכנס לחדרו ורואה אותו מכונס בתוך עצמו.},
	q{הייתי שואל 'מה קרה?'},
	q{והוא סיפר לי שכתבו עליו בעיתון.},
	q{עיתונאים מדרגה שלישית ורביעית ירדו עליו.},
	q{ראיתי וחשתי בזה שהוא מתחיל להישבר ושכל זה עולה לו על העצבים.},
	q{הסקר ביקש לבדוק גם אלו שירותי תיירות נוהגים הגולשים לרכוש באמצעות האינטרנט.},
	q{47 אחוז מהגולשים באינטרנט נוהגים לרכוש כרטיסי טיסה לחו"ל ברשת, לעומת 40 אחוז בסקר של שנת 2003.},
	q{43 אחוז נוהגים להזמין חדר במלון בארץ באינטרנט, לעומת 35 אחוז ב-2003.},
	q{בהזמנת חדרי מלון בחו"ל דרך האינטרנט חלה בשנת האחרונה דווקא ירידה: רק 39 אחוז הזמינו חדר במלון בחו"ל, לעומת 50 אחוז בסקר של 2003.},
	q{לעומת זאת, בהזמנת חדרי אירוח כפרי (כולל אכסניות נוער ובתי ספר שדה) חלה עלייה עצומה בשנה האחרונה.},
	q{29 אחוז מהגולשים אמרו כי הזמינו צימרים באמצעות האינטרנט, לעומת 13 אחוזים ב-2003.},
	q{בורסה: העליות מתחזקות; בזק מוסיפה כ-2.4%},
	q{מדד ת"א 100 נסחר בעליה של 0.81%; מדד ת"א 25 מוסיף כ-0.72%; ומדד התל-טק 15 מתחזק ב-1.08%.},
	q{האירו מתחזק ב-0.28% ונסחר סביב שער 5.713 שקלים לאירו}
);
use constant NUM_SENTENCES => scalar((SENTENCES));
use Test::More tests => 3 + NUM_SENTENCES;

use lib "lib";
use Lingua::HE::Sentence qw/get_sentences/;

binmode DATA,":utf8";
my $t=join '',<DATA>;
ok( $t ne '', "Text exists in the data file" );
my $sentences = get_sentences($t);
ok( defined $sentences , "get_sentences returned a defined scalar" );
is( scalar @$sentences, NUM_SENTENCES, "checking the number of sentences returned" );
is( $sentences->[$_], (SENTENCES)[$_], "Checking if segmentation of sentence number $_ is as expected" ) for 0 .. NUM_SENTENCES-1;
__DATA__
מטרתו של טקסט זה היא לשמש כעזר לבדיקת התוכנה לחלוקת טקסט עברי למשפטים אשר כתבתי. לטקסט זה נלווה טקסט נוסף, מקביל ובו החלוקה למשפטים כבר מוכנה. 

בהמשך, ארשום סוגים שונים של משפטים אשר אני מקווה שיסווגו נכונה ע"י התוכנה. "מה כבר ניתן לבדוק?" וודאי תשאלו... ובכן, נראה כי כל מופע של נקודה (.), סימן שאלה (?) וסימן קריאה (!) מהווים סימן חד-משמעי לסוף משפט. ובכן, לא כך בפועל. למעשה, סימנים אלה משמשים גם במקומות אחרים, למשל קיצורים שונים השאולי מאנגלית (לדוגמה, השם  'י.ב.מ.' היה, למעשה צריך כנראה להכתב בעברית כ-'יב"מ', אך מעטים אכן כותבים כך). עוד יוצאים מהכלל הם שילובים של סימנים אלה כגון: שלוש נקודות '...', סימן לתמיהה או הפתעה '?!' וכיוצא באלה. מקרים נוספים אשר מסמלים כנראה סוף משפט הם מקרים של יותר מתו אחד של שורה חדשה.

הנה, טקסט לדוגמה מתוך מכתב לדיירי בניין מאת יו"ר ועד הדיירים:

לגיא ולכל הדיירים שלום,

--- תחילת הטקסט ---

עפ"י חוות דעת של האגודה לתרבות הדיור – ניתן לכפות החלטת רוב רק על נושאים הקשורים לתחזוקתו התקינה של הבניין.

 

מכיוון שנושא חדר הכושר לא נופל בקטגוריה זו הרי שעל מנת לצאת לדרך צריכים לפעול עפ"י המלצת הוועד (מפגישתנו המשותפת עם חברי הוועדה ובנוכחות אבי ומיקי) ולהפעיל את החדר בשלבים – עפ"י יכולתנו הכספיות. יכול אמנם להיות שזה בניגוד להמלצתם של חלק מחברי הוועדה שבדקה את הנושא אבל בסופו של דבר הוועד הוא המוציא לפועל וההיגיון אומר – הפעלת חדר הכושר בשלבים. בשלב זה קל יותר להקים תשתית בסיסית שיכולה לכלול: מזגן, סורגים, מזרנים ושולחן פינג-פונג – כל זאת תוך גיוס של לא יותר מ300 ₪ מכל דייר. תשתית בסיסית מעין זו תשמש את כל הדיירים ללא יצירת קליקות או קבוצות. התשתית תשמש גם את אלו שרוצים להתעמל, גם לחוגי יוגה או בריאות, גם לילדים וגם סתם כיף של להתגלגל יחד בחדר.... התשתית תשרת את כלל האוכלוסייה בבניין. לפיכך, ההיגיון אומר שיהיה קל יחסית להעביר החלטה על גיוס של 300 ש"ח – כפי שהדבר מסתמן גם בטפסים/שאלונים שאני מקבל חזרה מהדיירים.

 

לעומת זאת, ההחלטה לגבי רכישת ציוד כושר מהווה למעלה מ 30% מתקציב ההשקעות הכולל (660 מתוך 1785) ומדובר בסכום משמעותי ביותר. בעיקר, השקעה זו אינה משרתת את כל הדיירים אלא רק חלק מהם ולכן נדרשת עבורה התייחסות שונה – הן עקב משקלה הסגולי הגבוה בסל ההשקעות והן עקב חילוקי הדעות לגביה (שהם חדים יותר מאשר בכל נושא אחר).

ההמלצות בעד ונגד משקפות את דעתם של רבים מהדיירים עימם שוחחנו והתכתבנו, ולכן מצאנו לנכון להביא את רוח הדברים והנימוקים בפני הדיירים.

(גם קיומם של ימי הולדת לא תתאפשר בשלב ראשון עקב מורכבות הנושא וחילוקי הדעות הקיימים סביבו).

 

יחד עם זאת, הדיירים אמרו את דברם והרוב אמנם מעוניין בחדר כושר. ולכן ניתן לצפות שהרוב גם ירתם לגיוס כספים עבור מכשירים ברוח העדפותיו אלו.

לפיכך אמונתי היא שאותם דיירים שהצביעו בעד חדר הכושר יצביעו גם בעד גיוס כסף לרכישת הציוד – ויעשו כן בעדיפות גבוהה ואז נוכל לממן לפחות חלק מהציוד.

 

בכל מקרה, כוונתנו היא להפעיל את חדר הכושר עוד במהלך חופשת הקיץ.

 

 

שלכם,

 

חנוך

--- סוף הטקסט ---

עוד כמה מקרים: מה זה?! אויש... סי.פי.אס. לא מבינים. וייי.

"בניגוד לאותן אבנים הרודיאניות מפורסמות בירושלים, היא גם ידעה לענות.  מה שבא ללמדך, שלו גברים היו חשים את סוד האשה, והן מצדן היו יותר רחומות, לא היתה אומללות גברית רבה כל-כך מוטחת לשווא בקיר אבנים..." קטע מתוך "על שלושה גשרים" מאת יונתן פיין, שפותח סדרת מקור חדשה בהוצאת "כרמל".

"לא אגזים אם אומר כי מבחינה פיננסית, בתקופתו של גברי עלינו לרמה אחרת לחלוטין ממה שהכרנו לפניו", העיד אבן עזרא בבית המשפט. "את המקרה הנוכחי (הכאת העיתונאי - מ.ג) אני מכיר דרך העיתונות ואני רוצה לומר שאולי זה קרה יותר במסגרת הרגשות. גברי מעולם לא היה חבר קרוב שלי, עבדנו צמוד וביחד, אבל למדתי לאהוב אותו. לפעמים הייתי נכנס לחדרו ורואה אותו מכונס בתוך עצמו. הייתי שואל 'מה קרה?' והוא סיפר לי שכתבו עליו בעיתון. עיתונאים מדרגה שלישית ורביעית ירדו עליו. ראיתי וחשתי בזה שהוא מתחיל להישבר ושכל זה עולה לו על העצבים. 


הסקר ביקש לבדוק גם אלו שירותי תיירות נוהגים הגולשים לרכוש באמצעות האינטרנט. 47 אחוז מהגולשים באינטרנט נוהגים לרכוש כרטיסי טיסה לחו"ל ברשת, לעומת 40 אחוז בסקר של שנת 2003. 43 אחוז נוהגים להזמין חדר במלון בארץ באינטרנט, לעומת 35 אחוז ב-2003. 



בהזמנת חדרי מלון בחו"ל דרך האינטרנט חלה בשנת האחרונה דווקא ירידה: רק 39 אחוז הזמינו חדר במלון בחו"ל, לעומת 50 אחוז בסקר של 2003. לעומת זאת, בהזמנת חדרי אירוח כפרי (כולל אכסניות נוער ובתי ספר שדה) חלה עלייה עצומה בשנה האחרונה. 29 אחוז מהגולשים אמרו כי הזמינו צימרים באמצעות האינטרנט, לעומת 13 אחוזים ב-2003.

בורסה: העליות מתחזקות; בזק מוסיפה כ-2.4%



מדד ת"א 100 נסחר בעליה של 0.81%; מדד ת"א 25 מוסיף כ-0.72%; ומדד התל-טק 15 מתחזק ב-1.08%. האירו מתחזק ב-0.28% ונסחר סביב שער 5.713 שקלים לאירו



