# If Tcl/Tk already have required treectrl package, then prepare dummy wrapper,
# otherwise do wrapper which wraps around trtreectrl tcl/tk module.

use strict;
use Getopt::Long;
use ExtUtils::MakeMaker;

GetOptions(
    "force!",  \(my $force=0),
    "help!",   \ my $help,
) || usage();
usage() if $help;
sub usage {
    print <<'EOT';
Usage: perl Makefile.PL [--force] [<makemaker opts>...]

if Tcl/Tk already have required treectrl package, then do nothing.
--force option means that rebuilding of treectrl will happen anyway.
EOT
    exit;
}

use Tcl::Tk;
my $int = new Tcl::Tk;
my $current_treectrl = eval {
    $int->_packageRequireTreectrl;
};
print STDERR "cur ver = $current_treectrl\n";

my @c = (
    qw(
	    ../generic/qebind
	    ../generic/tkTreeColumn
	    ../generic/tkTreeCtrl
	    ../generic/tkTreeDisplay
	    ../generic/tkTreeDrag
	    ../generic/tkTreeElem
	    ../generic/tkTreeHeader
	    ../generic/tkTreeItem
	    ../generic/tkTreeMarquee
	    ../generic/tkTreeNotify
	    ../generic/tkTreeStyle
	    ../generic/tkTreeTheme
	    ../generic/tkTreeUtils
    ),
    ($^O eq 'MSWin32' ? '../win/tkWinTree' : ()),
    ($^O eq 'linux' ? '../unix/tkUnixTree' : ()),
    ($^O eq 'cygwin' ? '../unix/tkUnixTree' : ()),
    ($^O eq 'darwin' ? '../macosx/tkMacOSXTree' : ()),
);


if ($current_treectrl && $current_treectrl ge '2.4.3' && !$force) {
    # tcl/tk already have the module - generate dummy module
    open my $fh, ">treectrl.pm";
    print $fh <<'EOS';
package Tcl::Tk::Tkwidget::treectrl;
# ATTENTION! this autogenerated dummy module here because your tcl/tk setup
# happen to already have the required treectrl widget
sub init {
    my $int = shift;
    $int->Eval('package require treectrl');
}
1;
EOS
    close $fh;
    WriteMakefile(
	NAME => "Tcl::Tk::Tkwidget::treectrl",
	PM => {'treectrl.pm' => 'Tcl/Tk/Tkwidget'},
	XS => {},
    );
}
else {
    my $write_makefile = 0;
    my ($tcl_incspec, $tcl_libspec, $tk_libspec, $defs, $libs);

    if ($^O eq 'cygwin' or $^O eq 'linux' or $^O eq 'darwin') {
	# salto mortale: build all needed *.o now
	mkdir "build";
	chdir "build";
	print STDERR "doing configure; make";
	if (1) {
	    system("../../configure") ||
	    system("make") || ($write_makefile=1);
	} else {
	    $write_makefile=1;
	}
	chdir "..";

	# now get config parameters from ./build/config.status 
	system("./build/config.status --file=tcl-conf-vars.sh");

	open my $fh, "<" . "tcl-conf-vars.sh";
	my $tcl_config = join '', <$fh>;
	close $fh;
	my ($tcl_includes) = $tcl_config=~/^TCL_INCLUDES='(.*?)'/m;
	my ($tk_includes)  = $tcl_config=~/^TK_INCLUDES='(.*?)'/m;
	my ($tcl_libs)     = ''; # $tcl_config=~/^TCL_LIBS='(.*?)'/m;
	my ($tk_libs)      = $tcl_config=~/^TK_LIBS='(.*?)'/m;
	my ($tcl_stub_lib_file)      = $tcl_config=~/^TCL_STUB_LIB_FILE='(.*?)'/m;
	my ($tk_stub_lib_file)      = $tcl_config=~/^TK_STUB_LIB_FILE='(.*?)'/m;
	my ($tcl_stub_lib_spec)      = $tcl_config=~/^TCL_STUB_LIB_SPEC='(.*?)'/m;
	my ($tk_stub_lib_spec)      = $tcl_config=~/^TK_STUB_LIB_SPEC='(.*?)'/m;
	($tcl_libspec)     = $tcl_config=~/^TCL_LIB_SPEC='(.*?)'/m;
	($tk_libspec)      = $tcl_config=~/^TK_LIB_SPEC='(.*?)'/m;
	($defs)            = $tcl_config=~/^DEFS='(.*?)'/m;
	$tcl_incspec = "$tcl_includes $tk_includes";
	$libs = "$tcl_libs $tk_libs  $tcl_stub_lib_spec $tk_stub_lib_spec"; #$tcl_libspec $tk_libspec
    }
    else {
	open my $fh, "<".$int->GetVar('tcl_library')."/../tkConfig.sh";
	my $tk_config = join '', <$fh>;
	close $fh;
	# TODO let's $int know these values
	open $fh, "<" . $int->GetVar('tcl_library')."/../tclConfig.sh";
	my $tcl_config = join '', <$fh>;
	close $fh;
	($tcl_incspec, $tcl_libspec, $tk_libspec, my $tcl_defs, my $tk_defs) = (
	    $tcl_config=~/^TCL_INCLUDE_SPEC='(.*?)'/m,
			  $tcl_config=~/^TCL_LIB_SPEC='(.*?)'/m,
					$tk_config=~/^TK_LIB_SPEC='(.*?)'/m,
						     $tcl_config=~/^TCL_DEFS='(.*?)'/m,
								$tk_config=~/^TK_DEFS='(.*?)'/m);
	$defs = "$tcl_defs $tk_defs";
    }


    # read tcl compile options
    my $DEFS = "$defs -DUSE_TCL_STUBS=1 -DUSE_TK_STUBS=1"=~y/\\//dr;
print STDERR "(tcl_incspec,tcl_libspec,tk_libspec)=($tcl_incspec, $tcl_libspec, $tk_libspec)\n";
    open my $fh_out, ">treectrl.pm";
    print $fh_out <<'EOS';
package Tcl::Tk::Tkwidget::treectrl;
require DynaLoader;
our @ISA = qw(DynaLoader);
__PACKAGE__->bootstrap;

# happen to NOT have the required treectrl widget
sub init {
    my $int = shift;
    $INC{'Tcl/Tk/Tkwidget/treectrl.pm'} =~ /^(.*)\// or die "?";
    $int->SetVar('::treectrl_library',"$1/../library");
    Tcl::Tk::Tkwidget::treectrl::Treectrl_Init($int);
    #$int->Eval('package require treectrl');
}
1;
EOS
    close $fh_out;
    if ($write_makefile) {
	WriteMakefile(
	    NAME => "Tcl::Tk::Tkwidget::treectrl",
	    #? VERSION => '2.4.2',
	    LICENSE => 'perl',
	    MIN_PERL_VERSION => '5.006',
	    META_MERGE => {
		"meta-spec" => { version => 2 },
		resources => {
		    repository => {
			type => 'git',
			web => 'https://github.com/vadrer/tktreectrl',
			url => 'https://github.com/vadrer/tktreectrl',
		    },
		    MailingList => 'mailto:tcltk@perl.org',
		},
		keywords => [qw(Tk Tcl/Tk tktreectrl GUI)],
	    },
	    PREREQ_PM => {
		'Tcl::Tk' => 1.0,
	    },
	    PMLIBDIRS    => ['../library', '../demos', '../doc'],
	    INC          => "$tcl_incspec -I../generic",
	    LIBS         => "$libs" . ($^O eq 'MSWin32' ? ' -lUxTheme' : ''),
	    OBJECT       => 'treectrl.o ' . join(' ', map {'build/'.s/^.*\///r . ".o"} @c),
	    DEFINE       => $DEFS,
	    dist         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
	);
    } else  {
	die "errors. will not write Makefile";
    }
}

sub MY::postamble {
    return join '', map {my $c = s/^.*\///r; <<"EOS"} @c;
$c\$(OBJ_EXT) : $_.c
	\$(CCCMD) \$(CCCDLFLAGS) "-I\$(PERL_INC)" \$(PASTHRU_DEFINE) \$(DEFINE) $_.c
EOS
}

