# Generated by default/object.tt
package Paws::CodePipeline::JobWorkerExecutorConfiguration;
  use Moose;
  has PollingAccounts => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'pollingAccounts', traits => ['NameInRequest']);
  has PollingServicePrincipals => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'pollingServicePrincipals', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodePipeline::JobWorkerExecutorConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodePipeline::JobWorkerExecutorConfiguration object:

  $service_obj->Method(Att1 => { PollingAccounts => $value, ..., PollingServicePrincipals => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodePipeline::JobWorkerExecutorConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->PollingAccounts

=head1 DESCRIPTION

Details about the polling configuration for the C<JobWorker> action
engine, or executor.

=head1 ATTRIBUTES


=head2 PollingAccounts => ArrayRef[Str|Undef]

The accounts in which the job worker is configured and might poll for
jobs as part of the action execution.


=head2 PollingServicePrincipals => ArrayRef[Str|Undef]

The service Principals in which the job worker is configured and might
poll for jobs as part of the action execution.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodePipeline>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

