NAME
====

Template::Prometheus

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.0.0

Description
===========

Objects to easily render templates of metrics for usage with Prometheus.

Installation
============

Install this module through [zef](https://github.com/ugexe/zef):

```sh
zef install Template::Prometheus
```

Example usage
=============

Exporting stats from the `App::CPAN` database
---------------------------------------------

    Template::Prometheus
	    .new(:prefix<cpan6>)
	    .add-metric(GaugeMetric.new(
		    name => "distribution_count",
		    value => ModuleRepo::count,
		    description => "Number of distributions in the database",
	    ))
	    .add-metric(GaugeMetric.new(
		    name => "module_count",
		    value => ModuleRepo::count-unique,
		    description => "Number of unique modules in the database",
	    ))
	    .add-metric(GaugeMetric.new(
		    name => "pause_id_count",
		    value => ModuleRepo::count-pause-ids,
		    description => "Number of PAUSE IDs in the database",
	    ))
	    .Str
	    .say

License
=======

This module is distributed under the terms of the AGPL-3.0.

