#! /usr/bin/env false

use v6.d;

use X::Grammar::DiceRolls::TooManyDice;
use X::Grammar::DiceRolls::TooManySides;

unit class Grammar::DiceRolls::ListActions;

has $.limit-dice = ∞;
has $.limit-sides = ∞;

has $!dice-count = 0;

method TOP ($/) {
	make (|$<dice>.map(*.made), |$<bonus>.map(*.made));
}

method dice ($/) {
	$!dice-count += +$<count>;

	X::Grammar::DiceRolls::TooManyDice.new(count => $!dice-count).throw if $!limit-dice < $!dice-count;
	X::Grammar::DiceRolls::TooManySides.new(count => +$<sides>).throw if $!limit-sides < +$<sides>;

	make (1..+$<count>).map({ (1..+$<sides>).pick }).Slip;
}

method bonus ($/) {
	$!dice-count++;

	X::Grammar::DiceRolls::TooManyDice.new(count => $!dice-count).throw if $!limit-dice < $!dice-count;

	make +$<value>;
}

=begin pod

=NAME    Grammar::DiceRolls::ListActions
=VERSION 0.3.1
=AUTHOR  Patrick Spek <p.spek@tyil.nl>

=begin LICENSE
Copyright © 2020

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
details.

You should have received a copy of the GNU Affero General Public License along
with this program.  If not, see http://www.gnu.org/licenses/.
=end LICENSE

=end pod

# vim: ft=raku noet sw=8 ts=8
