/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.ComponentSampleModelJAI;
import com.sun.media.jai.codecimpl.util.DataBufferUtils;
import com.sun.media.jai.codecimpl.util.FloatDoubleColorModel;
import com.sun.media.jai.codecimpl.util.JaiI18N;
import com.sun.media.jai.codecimpl.util.WritableRasterJAI;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class RasterFactory {
    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, Point point) {
        if (n4 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory0"));
        }
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = n4 - 1 - n5;
            ++n5;
        }
        return RasterFactory.createInterleavedRaster(n, n2, n3, n2 * n4, n4, nArray, point);
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, int n5, int[] nArray, Point point) {
        DataBuffer dataBuffer;
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory4"));
        }
        int n6 = nArray.length;
        int n7 = nArray[0];
        int n8 = 1;
        while (n8 < n6) {
            if (nArray[n8] > n7) {
                n7 = nArray[n8];
            }
            ++n8;
        }
        long l = (long)n7 + (long)n4 * (long)(n3 - 1) + (long)n5 * (long)(n2 - 1) + 1L;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory16"));
        }
        int n9 = (int)l;
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte(n9);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n9);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n9);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n9);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat(n9);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble(n9);
                break;
            }
            default: {
                throw new IllegalArgumentException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return RasterFactory.createInterleavedRaster(dataBuffer, n2, n3, n4, n5, nArray, point);
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, Point point) {
        if (n4 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory0"));
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = n5;
            nArray2[n5] = 0;
            ++n5;
        }
        return RasterFactory.createBandedRaster(n, n2, n3, n2, nArray, nArray2, point);
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        DataBuffer dataBuffer;
        int n5 = nArray2.length;
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory1"));
        }
        if (nArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory4"));
        }
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory2"));
        }
        int n6 = nArray[0];
        int n7 = nArray2[0];
        int n8 = 1;
        while (n8 < n5) {
            if (nArray[n8] > n6) {
                n6 = nArray[n8];
            }
            if (nArray2[n8] > n7) {
                n7 = nArray2[n8];
            }
            ++n8;
        }
        int n9 = n6 + 1;
        long l = (long)n7 + (long)n4 * (long)(n3 - 1) + (long)(n2 - 1) + 1L;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory16"));
        }
        int n10 = (int)l;
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte(n10, n9);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n10, n9);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n10, n9);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n10, n9);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat(n10, n9);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble(n10, n9);
                break;
            }
            default: {
                throw new IllegalArgumentException(JaiI18N.getString("RasterFactory3"));
            }
        }
        return RasterFactory.createBandedRaster(dataBuffer, n2, n3, n4, nArray, nArray2, point);
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int[] nArray, Point point) {
        return Raster.createPackedRaster(n, n2, n3, nArray, point);
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int n4, int n5, Point point) {
        if (n5 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory15"));
        }
        return Raster.createPackedRaster(n, n2, n3, n4, n5, point);
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, Point point) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory4"));
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        int n5 = dataBuffer.getDataType();
        switch (n5) {
            case 0: 
            case 1: {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(n5, n, n2, n4, n3, nArray);
                return Raster.createWritableRaster(pixelInterleavedSampleModel, dataBuffer, point);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int n6 = nArray[0];
                int n7 = nArray[0];
                int n8 = 1;
                while (n8 < nArray.length) {
                    n6 = Math.min(n6, nArray[n8]);
                    n7 = Math.max(n7, nArray[n8]);
                    ++n8;
                }
                if ((n7 -= n6) > n3) {
                    throw new IllegalArgumentException(JaiI18N.getString("RasterFactory5"));
                }
                if (n4 * n > n3) {
                    throw new IllegalArgumentException(JaiI18N.getString("RasterFactory6"));
                }
                if (n4 < n7) {
                    throw new IllegalArgumentException(JaiI18N.getString("RasterFactory7"));
                }
                ComponentSampleModelJAI componentSampleModelJAI = new ComponentSampleModelJAI(n5, n, n2, n4, n3, nArray);
                return Raster.createWritableRaster(componentSampleModelJAI, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("RasterFactory3"));
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, int[] nArray2, Point point) {
        if (point == null) {
            point = new Point(0, 0);
        }
        int n4 = dataBuffer.getDataType();
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory1"));
        }
        if (nArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory4"));
        }
        int n5 = nArray.length;
        if (nArray2.length != n5) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory2"));
        }
        ComponentSampleModelJAI componentSampleModelJAI = new ComponentSampleModelJAI(n4, n, n2, 1, n3, nArray, nArray2);
        switch (n4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Raster.createWritableRaster(componentSampleModelJAI, dataBuffer, point);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("RasterFactory3"));
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, Point point) {
        return Raster.createPackedRaster(dataBuffer, n, n2, n3, nArray, point);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, Point point) {
        return Raster.createPackedRaster(dataBuffer, n, n2, n3, point);
    }

    public static Raster createRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return Raster.createRaster(sampleModel, dataBuffer, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        if (point == null) {
            point = new Point(0, 0);
        }
        return RasterFactory.createWritableRaster(sampleModel, sampleModel.createDataBuffer(), point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return Raster.createWritableRaster(sampleModel, dataBuffer, point);
    }

    public static WritableRaster createWritableChild(WritableRaster writableRaster, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        SampleModel sampleModel;
        if (n < writableRaster.getMinX()) {
            throw new RasterFormatException(JaiI18N.getString("RasterFactory9"));
        }
        if (n2 < writableRaster.getMinY()) {
            throw new RasterFormatException(JaiI18N.getString("RasterFactory10"));
        }
        if (n + n3 > writableRaster.getWidth() + writableRaster.getMinX()) {
            throw new RasterFormatException(JaiI18N.getString("RasterFactory11"));
        }
        if (n2 + n4 > writableRaster.getHeight() + writableRaster.getMinY()) {
            throw new RasterFormatException(JaiI18N.getString("RasterFactory12"));
        }
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        if (nArray != null) {
            sampleModel = sampleModel2.createCompatibleSampleModel(sampleModel2.getWidth(), sampleModel2.getHeight());
            sampleModel = sampleModel.createSubsetSampleModel(nArray);
        } else {
            sampleModel = sampleModel2;
        }
        int n9 = n5 - n;
        int n10 = n6 - n2;
        return new WritableRasterJAI(sampleModel, dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(n7 + n9, n8 + n10), writableRaster);
    }

    public static SampleModel createBandedSampleModel(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5;
        if (n4 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory0"));
        }
        if (nArray == null) {
            nArray = new int[n4];
            n5 = 0;
            while (n5 < n4) {
                nArray[n5] = n5;
                ++n5;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[n4];
            n5 = 0;
            while (n5 < n4) {
                nArray2[n5] = 0;
                ++n5;
            }
        }
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory2"));
        }
        return new ComponentSampleModelJAI(n, n2, n3, 1, n2, nArray, nArray2);
    }

    public static SampleModel createBandedSampleModel(int n, int n2, int n3, int n4) {
        return RasterFactory.createBandedSampleModel(n, n2, n3, n4, null, null);
    }

    public static SampleModel createPixelInterleavedSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory4"));
        }
        int n6 = nArray[0];
        int n7 = nArray[0];
        int n8 = 1;
        while (n8 < nArray.length) {
            n6 = Math.min(n6, nArray[n8]);
            n7 = Math.max(n7, nArray[n8]);
            ++n8;
        }
        if ((n7 -= n6) > n5) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory5"));
        }
        if (n4 * n2 > n5) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory6"));
        }
        if (n4 < n7) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory7"));
        }
        switch (n) {
            case 0: 
            case 1: {
                return new PixelInterleavedSampleModel(n, n2, n3, n4, n5, nArray);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new ComponentSampleModelJAI(n, n2, n3, n4, n5, nArray);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("RasterFactory3"));
    }

    public static SampleModel createPixelInterleavedSampleModel(int n, int n2, int n3, int n4) {
        if (n4 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory0"));
        }
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray[n5] = n4 - 1 - n5;
            ++n5;
        }
        return RasterFactory.createPixelInterleavedSampleModel(n, n2, n3, n4, n4 * n2, nArray);
    }

    public static SampleModel createComponentSampleModel(SampleModel sampleModel, int n, int n2, int n3, int n4) {
        if (sampleModel instanceof BandedSampleModel) {
            return RasterFactory.createBandedSampleModel(n, n2, n3, n4);
        }
        return RasterFactory.createPixelInterleavedSampleModel(n, n2, n3, n4);
    }

    public static ComponentColorModel createComponentColorModel(int n, ColorSpace colorSpace, boolean bl, boolean bl2, int n2) {
        if (colorSpace == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory13"));
        }
        if (bl && n2 == 1) {
            throw new IllegalArgumentException(JaiI18N.getString("RasterFactory14"));
        }
        if (!bl) {
            bl2 = false;
            n2 = 1;
        }
        int n3 = colorSpace.getNumComponents();
        if (bl) {
            ++n3;
        }
        int n4 = DataBuffer.getDataTypeSize(n);
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = n4;
            ++n5;
        }
        switch (n) {
            case 0: {
                return new ComponentColorModel(colorSpace, nArray, bl, bl2, n2, n);
            }
            case 1: {
                return new ComponentColorModel(colorSpace, nArray, bl, bl2, n2, n);
            }
            case 3: {
                return new ComponentColorModel(colorSpace, nArray, bl, bl2, n2, n);
            }
            case 4: {
                return new FloatDoubleColorModel(colorSpace, bl, bl2, n2, n);
            }
            case 5: {
                return new FloatDoubleColorModel(colorSpace, bl, bl2, n2, n);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("RasterFactory8"));
    }
}

