
=begin comment

Smartcat Integration API

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: v1

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program.
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package Smartcat::Client::ClientApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use Smartcat::Client::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata( 'method_documentation' => {} );

sub new {
    my $class = shift;
    my $api_client;

    if ( $_[0] && ref $_[0] && ref $_[0] eq 'Smartcat::Client::ApiClient' ) {
        $api_client = $_[0];
    }
    else {
        $api_client = Smartcat::Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}

#
# client_create_client
#
# Create a new client with the specified name and return their ID.              Simply return the ID if a client with that name already exists
#
# @param string $name client&#39;s name (required)
{
    my $params = {
        'name' => {
            data_type   => 'string',
            description => 'client&#39;s name',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'client_create_client'} = {
        summary =>
'Create a new client with the specified name and return their ID.              Simply return the ID if a client with that name already exists',
        params  => $params,
        returns => 'string',
    };
}

# @return string
#
sub client_create_client {
    my ( $self, %args ) = @_;

    # verify the required parameter 'name' is set
    unless ( exists $args{'name'} ) {
        croak(
"Missing the required parameter 'name' when calling client_create_client"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/client/create';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    my $_body_data;

    # body params
    if ( exists $args{'name'} ) {
        $_body_data = $args{'name'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'string', $response );
    return $_response_object;
}

#
# client_get_client
#
#
#
# @param string $client_id  (required)
{
    my $params = {
        'client_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'client_get_client'} = {
        summary => '',
        params  => $params,
        returns => 'ClientModel',
    };
}

# @return ClientModel
#
sub client_get_client {
    my ( $self, %args ) = @_;

    # verify the required parameter 'client_id' is set
    unless ( exists $args{'client_id'} ) {
        croak(
"Missing the required parameter 'client_id' when calling client_get_client"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/client/{clientId}';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'client_id'} ) {
        my $_base_variable = "{" . "clientId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'client_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ClientModel', $response );
    return $_response_object;
}

#
# client_set_client_net_rate
#
#
#
# @param string $client_id  (required)
# @param string $net_rate_id  (required)
{
    my $params = {
        'client_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'net_rate_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'client_set_client_net_rate'} = {
        summary => '',
        params  => $params,
        returns => 'ClientModel',
    };
}

# @return ClientModel
#
sub client_set_client_net_rate {
    my ( $self, %args ) = @_;

    # verify the required parameter 'client_id' is set
    unless ( exists $args{'client_id'} ) {
        croak(
"Missing the required parameter 'client_id' when calling client_set_client_net_rate"
        );
    }

    # verify the required parameter 'net_rate_id' is set
    unless ( exists $args{'net_rate_id'} ) {
        croak(
"Missing the required parameter 'net_rate_id' when calling client_set_client_net_rate"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/client/{clientId}/set';

    my $_method       = 'PUT';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'net_rate_id'} ) {
        $query_params->{'netRateId'} =
          $self->{api_client}->to_query_value( $args{'net_rate_id'} );
    }

    # path params
    if ( exists $args{'client_id'} ) {
        my $_base_variable = "{" . "clientId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'client_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ClientModel', $response );
    return $_response_object;
}

1;
