package JIRA::REST::Class::Query;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents a JIRA query as an object.  Attempts to return an array of all results from the query.



sub issue_count { shift->data->{total} }


sub issues {
    my $self = shift;
    my @issues = map {
        $self->factory->make_object('issue', { data => $_ });
    } @{ $self->data->{issues} };
    return @issues;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Query - A helper class for C<JIRA::REST::Class> that represents a JIRA query as an object.  Attempts to return an array of all results from the query.

=head1 VERSION

version 0.01

=head1 METHODS

=head2 B<issue_count>

A count of the number of issues matched by the query.

=head2 B<issues>

Returns a list of C<JIRA::REST::Class::Issue> objects matching the query.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
