package ThreatDetector;

use strict;
use warnings;

our $VERSION = '0.01';

# Optionally load core components
use ThreatDetector::Parser;
use ThreatDetector::Classifier;
use ThreatDetector::Dispatcher;
use ThreatDetector::Reporter;

1;

__END__

=head1 NAME

ThreatDetector - Modular Apache log threat detection toolkit

=head1 SYNOPSIS

  use ThreatDetector;
  my $entry = ThreatDetector::Parser::parse_log_line($line);

=head1 DESCRIPTION

ThreatDetector is a modular Perl framework for parsing Apache logs and detecting security threats using specialized handlers and classifiers.

=head1 MODULES

=over

=item * ThreatDetector::Parser - Parses Apache logs

=item * ThreatDetector::Classifier - Detects threats using multiple strategies

=item * ThreatDetector::Dispatcher - Routes parsed data to handlers

=item * ThreatDetector::Reporter - Outputs or logs threats

=back

=head1 AUTHOR

Jason Hall <jason.kei.hall@gmail.com>

=head1 LICENSE

This library is free software; you may redistribute it and/or modify
it under the same terms as Perl itself.

=cut
