/*  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 * 
 *  Libmemcached library
 *
 *  Copyright (C) 2011 Data Differential, http://datadifferential.com/
 *  Copyright (C) 2006-2009 Brian Aker All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *
 *      * Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *
 *      * Redistributions in binary form must reproduce the above
 *  copyright notice, this list of conditions and the following disclaimer
 *  in the documentation and/or other materials provided with the
 *  distribution.
 *
 *      * The names of its contributors may not be used to endorse or
 *  promote products derived from this software without specific prior
 *  written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __LIBMEMCACHED_SASL_H__
#define __LIBMEMCACHED_SASL_H__

#if defined(LIBMEMCACHED_WITH_SASL_SUPPORT) && LIBMEMCACHED_WITH_SASL_SUPPORT
#include <sasl/sasl.h>
#else
#define sasl_callback_t void
#endif

#ifdef __cplusplus
extern "C" {
#endif

LIBMEMCACHED_API
void memcached_set_sasl_callbacks(memcached_st *ptr,
                                  const sasl_callback_t *callbacks);

LIBMEMCACHED_API
memcached_return_t  memcached_set_sasl_auth_data(memcached_st *ptr,
                                                 const char *username,
                                                 const char *password);

LIBMEMCACHED_API
memcached_return_t memcached_destroy_sasl_auth_data(memcached_st *ptr);


LIBMEMCACHED_API
sasl_callback_t *memcached_get_sasl_callbacks(memcached_st *ptr);

LIBMEMCACHED_LOCAL
memcached_return_t memcached_clone_sasl(memcached_st *clone, const  memcached_st *source);

LIBMEMCACHED_LOCAL
memcached_return_t memcached_sasl_authenticate_connection(memcached_server_st *server);

#ifdef __cplusplus
}
#endif

struct memcached_sasl_st {
  sasl_callback_t *callbacks;
  /*
   ** Did we allocate data inside the callbacks, or did the user
   ** supply that.
 */
  bool is_allocated;
};

#endif /* __LIBMEMCACHED_SASL_H__ */
