package App::Manoc::DB::ResultSet::Server;
#ABSTRACT: ResultSet class for Server

use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';


sub hypervisors {
    my $self = shift;

    my $rs = $self->search( { is_hypervisor => 1, decommissioned => 0 } );
    return wantarray ? $rs->all : $rs;
}


sub standalone_hypervisors {
    my $self = shift;

    my $rs = $self->hypervisors->search( { virtual_infr => undef } );
    return wantarray ? $rs->all : $rs;
}


sub logical_servers {
    my $self = shift;

    my $rs = $self->search( { vm_id => undef, serverhw_id => undef }, );
    return wantarray ? $rs->all : $rs;
}


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::Server - ResultSet class for Server

=head1 VERSION

version 2.99.2

=head1 METHODS

=head2 hypervisors

Resultset for non decommisioned hypervisors.

=head2 standalone_hypervisors

Resultset for non standalone hypervisors.

=head2 logical_servers

Resultset for non logical servers (no virtualmachine or hardware associated).

=head1 SEE ALSO

L<DBIx::Class::ResultSet>

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
