package App::Manoc::ControllerRole::CSVView;

use Moose::Role;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use MooseX::MethodAttributes::Role;
use namespace::autoclean;

requires 'object', 'object_list';

has csv_columns => (
    is      => 'rw',
    isa     => 'ArrayRef[Str]',
    default => sub { [] },
);

has csv_column_alias => (
    is      => 'rw',
    isa     => 'HashRef[Str]',
    default => sub { {} },
);


sub prepare_csv_object {
    my ( $self, $c, $row ) = @_;

    my $ret = [];
    foreach my $name ( @{ $self->csv_columns } ) {
        # default accessor is preferred
        my $val = $row->can($name) ? $row->$name : $row->get_column($name);
        push @$ret, $val;
    }
    return $ret;
}


sub list_csv : Chained('object_list') : PathPart('csv') : Args(0) {
    my ( $self, $c ) = @_;

    my $filename = $c->stash->{filename};
    $filename = $c->namespace();
    $filename =~ s|/|_|;

    if ( !@{ $self->csv_columns } ) {
        my @column_names = $c->stash->{resultset}->result_source->columns;
        $self->csv_columns( \@column_names );
    }

    my @headers;
    foreach my $col_name ( @{ $self->csv_columns } ) {
        my $name = $self->csv_column_alias->{$col_name} || $col_name;
        push @headers, $name;
    }

    my @data = map { $self->prepare_csv_object( $c, $_ ) } @{ $c->stash->{object_list} };
    $c->stash(
        columns      => \@headers,
        data         => \@data,
        filename     => $filename,
        suffix       => '.csv',
        current_view => 'CSV',
    );
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::ControllerRole::CSVView

=head1 VERSION

version 2.99.2

=head1 ACTIONS

=head2 list_csv

View chained to C<object_list> to generate a CSV file.
File name defaults to namespace and can be overridden via filename in stash.

=head1 METHODS

=head2 prepare_csv_object

Get an hashref from a row.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
