
package Shipment::FedEx::WSDL::TrackElements::TrackRequest;
$Shipment::FedEx::WSDL::TrackElements::TrackRequest::VERSION = '3.09';
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://fedex.com/ws/track/v9' }

__PACKAGE__->__set_name('TrackRequest');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Shipment::FedEx::WSDL::TrackTypes::TrackRequest
);

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackElements::TrackRequest

=head1 VERSION

version 3.09

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
TrackRequest from the namespace http://fedex.com/ws/track/v9.

=head1 NAME

Shipment::FedEx::WSDL::TrackElements::TrackRequest

=head1 METHODS

=head2 new

 my $element = Shipment::FedEx::WSDL::TrackElements::TrackRequest->new($data);

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackRequest
   WebAuthenticationDetail =>  { # Shipment::FedEx::WSDL::TrackTypes::WebAuthenticationDetail
     UserCredential =>  { # Shipment::FedEx::WSDL::TrackTypes::WebAuthenticationCredential
       Key =>  $some_value, # string
       Password =>  $some_value, # string
     },
   },
   ClientDetail =>  { # Shipment::FedEx::WSDL::TrackTypes::ClientDetail
     AccountNumber =>  $some_value, # string
     MeterNumber =>  $some_value, # string
     IntegratorId =>  $some_value, # string
     Localization =>  { # Shipment::FedEx::WSDL::TrackTypes::Localization
       LanguageCode =>  $some_value, # string
       LocaleCode =>  $some_value, # string
     },
   },
   TransactionDetail =>  { # Shipment::FedEx::WSDL::TrackTypes::TransactionDetail
     CustomerTransactionId =>  $some_value, # string
     Localization =>  { # Shipment::FedEx::WSDL::TrackTypes::Localization
       LanguageCode =>  $some_value, # string
       LocaleCode =>  $some_value, # string
     },
   },
   Version =>  { # Shipment::FedEx::WSDL::TrackTypes::VersionId
     ServiceId =>  $some_value, # string
     Major =>  $some_value, # int
     Intermediate =>  $some_value, # int
     Minor =>  $some_value, # int
   },
   SelectionDetails =>  { # Shipment::FedEx::WSDL::TrackTypes::TrackSelectionDetail
     CarrierCode => $some_value, # CarrierCodeType
     OperatingCompany => $some_value, # OperatingCompanyType
     PackageIdentifier =>  { # Shipment::FedEx::WSDL::TrackTypes::TrackPackageIdentifier
       Type => $some_value, # TrackIdentifierType
       Value =>  $some_value, # string
     },
     TrackingNumberUniqueIdentifier =>  $some_value, # string
     ShipDateRangeBegin =>  $some_value, # date
     ShipDateRangeEnd =>  $some_value, # date
     ShipmentAccountNumber =>  $some_value, # string
     SecureSpodAccount =>  $some_value, # string
     Destination =>  { # Shipment::FedEx::WSDL::TrackTypes::Address
       StreetLines =>  $some_value, # string
       City =>  $some_value, # string
       StateOrProvinceCode =>  $some_value, # string
       PostalCode =>  $some_value, # string
       UrbanizationCode =>  $some_value, # string
       CountryCode =>  $some_value, # string
       CountryName =>  $some_value, # string
       Residential =>  $some_value, # boolean
     },
     PagingDetail =>  { # Shipment::FedEx::WSDL::TrackTypes::PagingDetail
       PagingToken =>  $some_value, # string
       NumberOfResultsPerPage =>  $some_value, # nonNegativeInteger
     },
     CustomerSpecifiedTimeOutValueInMilliseconds =>  $some_value, # nonNegativeInteger
   },
   TransactionTimeOutValueInMilliseconds =>  $some_value, # nonNegativeInteger
   ProcessingOptions => $some_value, # TrackRequestProcessingOptionType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
