/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.code.DCPList;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@TitleProperty(name="operationName")
@XmlType(name="SV_OperationMetadata_Type", namespace="http://www.isotc211.org/2005/srv", propOrder={"operationName", "distributedComputingPlatforms", "operationDescription", "invocationName", "parameters", "connectPoints", "dependsOn"})
@XmlRootElement(name="SV_OperationMetadata", namespace="http://www.isotc211.org/2005/srv")
@UML(identifier="SV_OperationMetadata", specification=Specification.ISO_19115)
public class DefaultOperationMetadata
extends ISOMetadata {
    private static final long serialVersionUID = -3513177609655567627L;
    private String operationName;
    private Collection<CodeList<?>> distributedComputingPlatforms;
    private InternationalString operationDescription;
    private InternationalString invocationName;
    private Collection<OnlineResource> connectPoints;
    private Collection<ParameterDescriptor<?>> parameters;
    private List<DefaultOperationMetadata> dependsOn;

    public DefaultOperationMetadata() {
    }

    public DefaultOperationMetadata(DefaultOperationMetadata defaultOperationMetadata) {
        super(defaultOperationMetadata);
        if (defaultOperationMetadata != null) {
            this.operationName = defaultOperationMetadata.getOperationName();
            this.distributedComputingPlatforms = this.copyCollection(defaultOperationMetadata.getDistributedComputingPlatforms(), CodeList.class);
            this.operationDescription = defaultOperationMetadata.getOperationDescription();
            this.invocationName = defaultOperationMetadata.getInvocationName();
            this.connectPoints = this.copyCollection(defaultOperationMetadata.getConnectPoints(), OnlineResource.class);
            this.parameters = this.copySet(defaultOperationMetadata.getParameters(), ParameterDescriptor.class);
            this.dependsOn = this.copyList(defaultOperationMetadata.getDependsOn(), DefaultOperationMetadata.class);
        }
    }

    @XmlElement(name="operationName", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="operationName", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String string) {
        this.checkWritePermission();
        this.operationName = string;
    }

    @XmlJavaTypeAdapter(value=DCPList.class)
    @XmlElement(name="DCP", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="distributedComputingPlatform", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CodeList<?>> getDistributedComputingPlatforms() {
        this.distributedComputingPlatforms = this.nonNullCollection(this.distributedComputingPlatforms, CodeList.class);
        return this.distributedComputingPlatforms;
    }

    public void setDistributedComputingPlatforms(Collection<? extends CodeList<?>> collection) {
        this.distributedComputingPlatforms = this.writeCollection(collection, this.distributedComputingPlatforms, CodeList.class);
    }

    @XmlElement(name="operationDescription", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="operationDescription", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getOperationDescription() {
        return this.operationDescription;
    }

    public void setOperationDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.operationDescription = internationalString;
    }

    @XmlElement(name="invocationName", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="invocationName", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getInvocationName() {
        return this.invocationName;
    }

    public void setInvocationName(InternationalString internationalString) {
        this.checkWritePermission();
        this.invocationName = internationalString;
    }

    @XmlElement(name="connectPoint", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="connectPoint", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getConnectPoints() {
        this.connectPoints = this.nonNullCollection(this.connectPoints, OnlineResource.class);
        return this.connectPoints;
    }

    public void setConnectPoints(Collection<? extends OnlineResource> collection) {
        this.connectPoints = this.writeCollection(collection, this.connectPoints, OnlineResource.class);
    }

    @XmlElement(name="parameters", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="parameters", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<ParameterDescriptor<?>> getParameters() {
        this.parameters = this.nonNullCollection(this.parameters, ParameterDescriptor.class);
        return this.parameters;
    }

    public void setParameters(Collection<? extends ParameterDescriptor<?>> collection) {
        this.parameters = this.writeCollection(collection, this.parameters, ParameterDescriptor.class);
    }

    @XmlElement(name="dependsOn", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="dependsOn", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public List<DefaultOperationMetadata> getDependsOn() {
        this.dependsOn = this.nonNullList(this.dependsOn, DefaultOperationMetadata.class);
        return this.dependsOn;
    }

    public void setDependsOn(List<? extends DefaultOperationMetadata> list) {
        this.dependsOn = this.writeList(list, this.dependsOn, DefaultOperationMetadata.class);
    }
}

