=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::MarkdownExportOptions;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ExportOptions;
use AsposeSlidesCloud::Object::FontFallbackRule;
use AsposeSlidesCloud::Object::FontSubstRule;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Provides options that control how a presentation is saved in Html5 format.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ format } = 'md';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Provides options that control how a presentation is saved in Html5 format.',
                                  class => 'MarkdownExportOptions',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'default_regular_font' => {
    	datatype => 'string',
    	base_name => 'DefaultRegularFont',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'delete_embedded_binary_objects' => {
    	datatype => 'boolean',
    	base_name => 'DeleteEmbeddedBinaryObjects',
    	description => 'True to delete delete all embedded binary objects.',
    	format => '',
    	read_only => '',
    		},
    'gradient_style' => {
    	datatype => 'string',
    	base_name => 'GradientStyle',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'font_fallback_rules' => {
    	datatype => 'ARRAY[FontFallbackRule]',
    	base_name => 'FontFallbackRules',
    	description => 'Gets of sets list of font fallback rules.',
    	format => '',
    	read_only => '',
    		},
    'font_subst_rules' => {
    	datatype => 'ARRAY[FontSubstRule]',
    	base_name => 'FontSubstRules',
    	description => 'Gets of sets list of font substitution rules.',
    	format => '',
    	read_only => '',
    		},
    'skip_java_script_links' => {
    	datatype => 'boolean',
    	base_name => 'SkipJavaScriptLinks',
    	description => 'True to skip hyperlinks with javascript calls when saving the presentation.',
    	format => '',
    	read_only => '',
    		},
    'format' => {
    	datatype => 'string',
    	base_name => 'Format',
    	description => 'Export format.',
    	format => '',
    	read_only => '',
    		},
    'export_type' => {
    	datatype => 'string',
    	base_name => 'ExportType',
    	description => 'Specifies markdown specification to convert presentation. Default is TextOnly.',
    	format => '',
    	read_only => '',
    		},
    'flavor' => {
    	datatype => 'string',
    	base_name => 'Flavor',
    	description => 'Specifies markdown specification to convert presentation. Default is MultiMarkdown.',
    	format => '',
    	read_only => '',
    		},
    'new_line_type' => {
    	datatype => 'string',
    	base_name => 'NewLineType',
    	description => 'Specifies whether the generated document should have new lines of \\\\r(Macintosh), \\\\n(Unix) or \\\\r\\\\n(Windows). Default is Unix.',
    	format => '',
    	read_only => '',
    		},
    'images_save_folder_name' => {
    	datatype => 'string',
    	base_name => 'ImagesSaveFolderName',
    	description => 'Specifies folder name to save images. Default is Images. ',
    	format => '',
    	read_only => '',
    		},
    'show_slide_number' => {
    	datatype => 'boolean',
    	base_name => 'ShowSlideNumber',
    	description => 'Specifies whether the generated document should include slide number. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'show_comments' => {
    	datatype => 'boolean',
    	base_name => 'ShowComments',
    	description => 'Specifies whether the generated document should include comments. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'show_hidden_slides' => {
    	datatype => 'boolean',
    	base_name => 'ShowHiddenSlides',
    	description => 'Specifies whether the generated document should include hidden slides. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'remove_empty_lines' => {
    	datatype => 'boolean',
    	base_name => 'RemoveEmptyLines',
    	description => 'true to remove empty or whitespace-only lines from the final Markdown output. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'handle_repeated_spaces' => {
    	datatype => 'string',
    	base_name => 'HandleRepeatedSpaces',
    	description => 'Specifies how repeated space characters are preserved to maintain visual alignment. ',
    	format => '',
    	read_only => '',
    		},
    'slide_number_format' => {
    	datatype => 'string',
    	base_name => 'SlideNumberFormat',
    	description => 'The format of slide number headers. ',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'default_regular_font' => 'string',
    'delete_embedded_binary_objects' => 'boolean',
    'gradient_style' => 'string',
    'font_fallback_rules' => 'ARRAY[FontFallbackRule]',
    'font_subst_rules' => 'ARRAY[FontSubstRule]',
    'skip_java_script_links' => 'boolean',
    'format' => 'string',
    'export_type' => 'string',
    'flavor' => 'string',
    'new_line_type' => 'string',
    'images_save_folder_name' => 'string',
    'show_slide_number' => 'boolean',
    'show_comments' => 'boolean',
    'show_hidden_slides' => 'boolean',
    'remove_empty_lines' => 'boolean',
    'handle_repeated_spaces' => 'string',
    'slide_number_format' => 'string'
} );

__PACKAGE__->attribute_map( {
    'default_regular_font' => 'DefaultRegularFont',
    'delete_embedded_binary_objects' => 'DeleteEmbeddedBinaryObjects',
    'gradient_style' => 'GradientStyle',
    'font_fallback_rules' => 'FontFallbackRules',
    'font_subst_rules' => 'FontSubstRules',
    'skip_java_script_links' => 'SkipJavaScriptLinks',
    'format' => 'Format',
    'export_type' => 'ExportType',
    'flavor' => 'Flavor',
    'new_line_type' => 'NewLineType',
    'images_save_folder_name' => 'ImagesSaveFolderName',
    'show_slide_number' => 'ShowSlideNumber',
    'show_comments' => 'ShowComments',
    'show_hidden_slides' => 'ShowHiddenSlides',
    'remove_empty_lines' => 'RemoveEmptyLines',
    'handle_repeated_spaces' => 'HandleRepeatedSpaces',
    'slide_number_format' => 'SlideNumberFormat'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
