# AsposeCellsCloud::Object::Worksheet

## Load the model package
```perl
use AsposeCellsCloud::Object::Worksheet;
```

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**index** | **int** | Gets the index of sheet in the worksheets collection.              | 
**pictures** | [**LinkElement**](LinkElement.md) |  | [optional] 
**charts** | [**LinkElement**](LinkElement.md) |  | [optional] 
**comments** | [**LinkElement**](LinkElement.md) |  | [optional] 
**hyperlinks** | [**LinkElement**](LinkElement.md) |  | [optional] 
**is_visible** | **boolean** | Represents if the worksheet is visible.              | [optional] 
**view_type** | **string** | Gets and sets the view type. | [optional] 
**type** | **string** | Represents worksheet type | [optional] 
**is_gridlines_visible** | **boolean** | Gets or sets a value indicating whether the gridelines are visible.Default     is true. | [optional] 
**is_row_column_headers_visible** | **boolean** | Gets or sets a value indicating whether the worksheet will display row and column headers.Default is true.              | [optional] 
**is_page_break_preview** | **boolean** | Indications the specified worksheet is shown in normal view or page break preview. | [optional] 
**display_zeros** | **boolean** | True if zero values are displayed. | [optional] 
**transition_evaluation** | **boolean** | Flag indicating whether the Transition Formula Evaluation (Lotus compatibility) option is enabled.              | [optional] 
**display_right_to_left** | **boolean** | Indicates if the specified worksheet is displayed from right to left instead    of from left to right.  Default is false.              | [optional] 
**first_visible_column** | **int** | Represents first visible column index. | [optional] 
**ole_objects** | [**LinkElement**](LinkElement.md) |  | [optional] 
**is_outline_shown** | **boolean** | Indicates whether show outline.              | [optional] 
**name** | **string** | Gets or sets the name of the worksheet.              | [optional] 
**auto_shapes** | [**LinkElement**](LinkElement.md) |  | [optional] 
**cells** | [**LinkElement**](LinkElement.md) |  | [optional] 
**validations** | [**LinkElement**](LinkElement.md) |  | [optional] 
**zoom** | **int** | Represents the scaling factor in percent. It should be btween 10 and 400.              | [optional] 
**conditional_formattings** | [**LinkElement**](LinkElement.md) |  | [optional] 
**is_selected** | **boolean** | Indicates whether this worksheet is selected when the workbook is opened. | [optional] 
**tab_color** | [**Color**](Color.md) | Represents worksheet tab color. | [optional] 
**first_visible_row** | **int** | Represents first visible row index.              | [optional] 
**transition_entry** | **boolean** | Flag indicating whether the Transition Formula Entry (Lotus compatibility) option is enabled. | [optional] 
**visibility_type** | **string** | Indicates the state for this sheet visibility              | [optional] 
**is_ruler_visible** | **boolean** | Indicates whether the ruler is visible. Only apply for page break preview. | [optional] 
**links** | [**ARRAY[Link]**](Link.md) |  | [optional] 
**is_protected** | **boolean** | Indicates if the worksheet is protected. | 
**merged_cells** | [**LinkElement**](LinkElement.md) |  | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


