// new-guid
//
// generate/output a new GUID
// [an example of embedded perl for C# (using msscript.ocx and PerlScript)]

// Author: Roy Ivy III; copyright (c) 2009; license: Artistic v2.0 (http://opensource.org/licenses/artistic-license-2.0.php)

// REQUIRES: 
// 1) PerlScript (with ActivePerl [URL: http://www.activestate.com/activeperl ]) { As of 2009-03, ActivePerl has the only freely available perl Active Scripting engine [see URL: http://en.wikipedia.org/wiki/Active_Scripting ]}
// 2) msscript.ocx (included with XP and VISTA [or sct10en.exe from MS @ URL: http://www.microsoft.com/downloads/details.aspx?FamilyId=D7E31492-2595-49E6-8C02-1426FEC693AC ])
// 3) NET Framework v2.0+ (installed with VISTA or [for XP] via download from MS [URLs: (v2.0) http://msdn.microsoft.com/en-us/netframework/aa731542.aspx ; (v3.5) http://msdn.microsoft.com/en-us/netframework/cc378097.aspx ])

// Discussions of embedded perl
// URLref: http://www.perlmonks.org/?node_id=530344
// URLrefs: http://weblogs.asp.net/rosherove/articles/dotnetscripting.aspx ; http://msdn.microsoft.com/en-us/magazine/cc301954.aspx ; http://msdn.microsoft.com/en-us/library/ms974577.aspx ; http://social.msdn.microsoft.com/Forums/en-US/vclanguage/thread/7b04ca15-7139-433a-ad3c-934a02175a5b/ ; http://support.microsoft.com/kb/229669 ; http://social.msdn.microsoft.com/forums/en-US/netfxjscript/thread/96d4eeb5-1e49-4ce1-b631-a8a8fd70501b/ 
// URLrefs to WSC: http://www.xav.com/perl/Windows/windows_script_components.html
// URLrefs for PerlEz: http://www.perlmonks.org/?node_id=717198
// URLrefs for perl as external process: http://stackoverflow.com/questions/649993/how-do-i-call-perl-script-in-c-application
// URLrefs for standalone exes: http://www.perlmonks.org/?node_id=215299
// URLrefs for libperl++: http://www.perl.org/tpc/1998/User_Applications/When%20the%20STL%20Isn't%20Enough/paper.html

using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Text.RegularExpressions;
using System.Windows.Forms;

// Startup Code => URLref: [Paint.NET startup code] http://www.koders.com/csharp/fidAC5BC7F85A9D8970536A8AF55D06B90055E1D9DA.aspx?s=zoom
// Embedded DLLs => URLref: http://stackoverflow.com/questions/96732/embedding-a-dll-to-be-used-by-another
// Embedded DLL alternative [netz: .NET compression/packing] => URLref: http://madebits.com/netz/index.php

namespace PROGRAM { public sealed class PROGRAM {

private static PROGRAM instance;
private string[] args;

private string perlVERSION = @"
use version qw(); our $VERSION; { my $defaultVERSION = '0.1'; my $generate_alphas = 0; $VERSION = ( $defaultVERSION, qw( $Version: 0.1.2 $ ))[-2]; if ($generate_alphas) { $VERSION =~ /(\d+)\.(\d+)\.(\d+)(?:\.)?(.*)/; $VERSION = $1.'.'.$2.((!$4&&($2%2))?'_':'.').$3.($4?((($2%2)?'_':'.').$4):q{}); $VERSION = version::qv( $VERSION ); }; } ## no critic ( ProhibitCallsToUnexportedSubs ProhibitCaptureWithoutTest ProhibitNoisyQuotes ProhibitMixedCaseVars ProhibitMagicNumbers)
";

private string POD = @"
=head1 NAME

new-guid - generate a new GUID

=head1 VERSION

This document describes C<new-guid> ($Version: 0.1.2 $).

=head1 SYNOPSIS

new-guid [B<<option(s)>>]

=begin HIDDEN-OPTIONS

Options:

		--version       version message
	-?, --help          brief help message

=end HIDDEN-OPTIONS

=head1 OPTIONS

=over

=item --version

=item --usage

=item --help, -?

=item --man

Print the usual program information

=back

=head1 DESCRIPTION

B<new-guid> will generate and print a new Windows GUID.

=head1 COMPILATION

To compile this program, run the following command:

	./build
	
The NET Framework v2.0 or later is required for a successful compilation. And installation of PerlScript and msscript.ocx are required to run the resulting program.

The NET Framework v2.0+ can be obtained via download from Microsoft [URLs: (v2.0) L<http://msdn.microsoft.com/en-us/netframework/aa731542.aspx> ; (v3.5) L<http://msdn.microsoft.com/en-us/netframework/cc378097.aspx> ]).

PerlScript is an installation option with ActivePerl (from URL: L<http://www.activestate.com/activeperl> ) and is selected for install with the default installation options. (As of March 2009, ActivePerl has the only freely available perl Active Scripting engine [see URL: L<http://en.wikipedia.org/wiki/Active_Scripting> ].)

C<msscript.ocx> is the Microsoft MSScriptControl ActiveX control (included with most installations of XP and VISTA [or downloadable as C<sct10en.exe> from Microsoft @ URL: L<http://www.microsoft.com/downloads/details.aspx?FamilyId=D7E31492-2595-49E6-8C02-1426FEC693AC> ]). If present on the system (at C:\WINDOWS\System32\msscript.ocx) but not working correctly, it can be registered with C<C:\WINDOWS\System32\regsvr32 C:\WINDOWS\System32\msscript.ocx>.

=head1 AUTHOR

Roy Ivy III <rivy[at]cpan[dot]org>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2009, Roy Ivy III <rivy[at]cpan[dot]org>. All rights reserved. This module is free software; you can redistribute it and/or modify it under the Perl Artistic License v2.0. See L<http://opensource.org/licenses/artistic-license-2.0.php>.

=cut
";

MSScriptControl.ScriptControlClass interpreter = null;

private PROGRAM(string[] args)
{//TODO: why is this done/needed? COMMENT why...
    this.args = args;
}
private PROGRAM()
{
}

public class PRValue
{
//defined as == string :or: PRValue[]
private string s;
private PRValue[] a;	// can be interpreted/flattened into a string[] or Dictionary<string, string>

public string S 
	{ 
	get
		{
		if (s != null) { return s; } 
		else if (a != null) { string r = ""; string sep = ""; foreach (PRValue p in a) { r += sep + p.ToString(); sep = " "; } return r; }
		else return null;
		} 
	set{ s = value; a = null; } 
	}
public PRValue[] A { get{ return a; } set{ a = value; s = null; } }

public PRValue( ) { this.s = null; this.a = null; }
public PRValue( PRValue p ) { this.s = null; this.a = null; if (p.A != null) { this.a = p.A; } else if (p.S != null) { this.s = p.S; } }
public PRValue( string s ) { this.s = s; this.a = null; }
public PRValue( PRValue[] a ) { this.a = a; this.s = null; }

public bool IsString()
{
	return ( this.s != null );
}
public bool IsArray()
{
	return ( this.a != null );
}
public override string ToString() 
	{ 
	return S;	//??: return "" if s == null?
	}
public string[] ToArray() 
	{ 
	string[] r = new string[]{}; 
	if (A != null) { r = new string[A.Length]; for (int i=0; i<A.Length; i++) {r[i] = A[i].S;} return r; }
	else if (S != null) { r = new string[1]; r[0] = S; return r; }
	else return r; //??: throw?
	}
public Dictionary<string, string> ToDictionary() 
	{ 
	Dictionary<string, string> r = new Dictionary<string, string>();
	if (A != null) 
		{// interpret array as a flattened dictionary/HASH
		//r = new Dictionary<string, string>();
		//Console.WriteLine( "A.Length = {0}", A.Length );
		for (int i = 0; i < A.Length/2; i++) 
			{ 
			//Console.WriteLine( "A[] = {0} => {1}", A[2*i], A[2*i+1] );
			r[A[2*i].S] = A[2*i+1].S;
			}
		if ((A.Length % 2) == 1) { r[A[A.Length-1].S] = ""; }
		return r; 
		}
	else if (S != null) { /* r = new Dictionary<string, string>(); */ r[S] = ""; return r;}
	else return r; //??: throw?
	}
}

public PRValue _decode( string s )
{
	List<PRValue> o = new List<PRValue>();
	bool isError = false;
	
	s =  s.TrimStart();
	isError = s.StartsWith("ERROR=");
	//Console.WriteLine("s.IndexOf('=') = {0}", s.IndexOf('='));
	s = s.Remove( 0, s.IndexOf('=')+1 );
	//Console.WriteLine("1.s = `{0}`", s);
	
	Regex RE;
	MatchCollection theMatches;
	while (s != "")		//??: String.IsNullOrEmpty( s )
		{
		RE = new Regex( @"^([^\ \(]+(?:\ |$)|\ )(.*)$", RegexOptions.IgnoreCase);
		for ( theMatches = RE.Matches( s ); theMatches.Count > 0; theMatches = RE.Matches(s) )
			{//# parse and replace {xx} encoded characters; add to array
			//Console.WriteLine("theMatches[0].Groups[1].Value = `{0}`", theMatches[0].Groups[1].Value);
			//Console.WriteLine("theMatches[0].Groups[2].Value = `{0}`", theMatches[0].Groups[2].Value);
			string decoded = null;
			if ( theMatches[0].Groups[1].Value != " " )
				{
				Regex RE_decode = new Regex("{([0-9a-f]+)}", RegexOptions.IgnoreCase);
				MatchCollection	decodeMatches = RE_decode.Matches(theMatches[0].Groups[1].Value);
				for (int j=0; j < decodeMatches.Count; j++)
					{
					//Console.WriteLine("m[{0}].Groups[1] = {1}", j, decodeMatches[j].Groups[1].Value);
					decoded = decoded + Convert.ToChar(Convert.ToInt32(decodeMatches[j].Groups[1].Value, 16)).ToString();	// ??: works for UNICODE characters?
					}
				}
			o.Add( new PRValue( decoded ) );
			s = theMatches[0].Groups[2].Value;
			//Console.WriteLine("3.s = `{0}`", s);
			}
		if ( Regex.Match( s, @"^\((.*)$" ).Success )
			{
			RE = new Regex( @"^\((?<SUBLIST>((?<OPEN>)\(|\)(?<CLOSE-OPEN>)|[^\(\)]*)+(?(OPEN)(?!)))\)(?:\ |$)(?<TRAIL>.*)$" );
			MatchCollection subMatches;
			if ( (subMatches = RE.Matches( s )).Count > 0 )
				{
				//Console.WriteLine( "subM[0].Groups[0].Value = `{0}`", subMatches[0].Groups[0].Value ); 
				//Console.WriteLine( "subM[0].Groups[SUBLIST].Value = `{0}`", subMatches[0].Groups["SUBLIST"].Value ); 
				//Console.WriteLine( "subM[0].Groups[TRAIL].Value = `{0}`", subMatches[0].Groups["TRAIL"].Value ); 
				o.Add( _decode( subMatches[0].Groups["SUBLIST"].Value ));
				s = subMatches[0].Groups["TRAIL"].Value;
				//Console.WriteLine("4.s = `{0}`", s);
				}
			else { throw new System.Exception( "[decode] unbalanced sublist parenthesis" ); }
			}
		}

	if (isError) { throw new ArgumentException( "PerlScript ERROR: "+ (new PRValue( o.ToArray() )).ToString() ); }

	if ( o.Count == 0 ) { return new PRValue(); }
	else if ( o.Count == 1 ) { return new PRValue( o.ToArray() ); }
	else return new PRValue( o.ToArray() );
}

public PRValue PerlEval( string program )
{
	return PerlEval( program, new string[]{} );
}
public PRValue PerlEval( string program, string[] args )
{
	// NOTE: some limitations: $0 eq {}; input @_ to <program> is READONLY, some limitations on writing to filehandles
	if (interpreter == null) 
		{ 
		try
			{
			interpreter = new MSScriptControl.ScriptControlClass();
			}
		catch( System.Runtime.InteropServices.COMException )
			{
			Console.WriteLine( @"Missing or unregistered msscript.ocx ([download/install from 'http://www.microsoft.com/downloads/details.aspx?FamilyId=D7E31492-2595-49E6-8C02-1426FEC693AC'] or [register with 'C:\WINDOWS\System32\regsvr32 C:\WINDOWS\System32\msscript.ocx'])" );
			throw;
			}
		try
			{
			interpreter.Language = "PerlScript";
			}
		catch( System.Exception )
			{
			Console.WriteLine( @"Missing PerlScript ([download/install from 'http://www.activestate.com/activeperl'])" );
			}
		}

	interpreter.Reset();

	interpreter.AddCode( @"
		sub encode
		{#encode( $|@ )
			my @args = @_;
			my $o = q{};
			my $first = 1;
			my $sep = q{ };
			foreach my $arg (@args)
				{
				if (ref($arg))
					{
					#print qq{ref [}.ref($arg).qq{]\n};
					if (ref($arg) eq 'SCALAR') { $o .= ($first?q{}:$sep) . encode(${$arg}); }
					elsif (ref($arg) eq 'ARRAY') { $o .= ($first?q{}:$sep) . '(' . encode(@{$arg}) . ')'; }
					elsif (ref($arg) eq 'HASH') { $o .= ($first?q{}:$sep) . '(' . encode(%{$arg}) . ')'; }
					}
				else
					{
					#print qq{arg => }.$arg.qq{\n};
					$s = $arg;
					$s =~ s/(.)/sprintf(qq{{%x}},ord($1))/eg;
					$o .= ($first ? q{} : $sep) . $s;
					}
				$first = 0;
				}
			return $o;
		}
		" );
	program = Regex.Replace(program, @"([{}])", @"\$1");	// replace all internal begin/end brackets in program with escaped versions before .AddCode
	//Console.WriteLine( "program = {0}" , program ); 
	interpreter.AddCode( "sub e { $o = q{}; @o = eval q{" + program + @"}; if ($@ ne q{}) { $o = 'ERROR='.encode($@); } else { $o = 'ARRAY='.encode(@o); } $o; }" );
	object[] e_args = new object[args.Length];
	for ( int i = 0; i < args.Length; i++ ) { e_args[i] = args[i]; }
	object r = interpreter.Run( "e", ref e_args );	// eval function in SCALAR context (no other context possible)
	// r can be null if the script uses exit()
	
	if (r == null) { return null; }
	else { return _decode(r.ToString()); }
}

string tempPODfile()
{
	//string filename = Path.GetTempFileName();
	string filename = Path.Combine( Path.GetTempPath(), Path.GetFileNameWithoutExtension( Application.ExecutablePath )+"."+Path.GetRandomFileName()+".POD" );
	StreamWriter writer = new StreamWriter( filename, false ); 
	writer.WriteLine( POD ); 
	writer.Close();

	return filename;
}

public int Start(string[] args)
{
PRValue p = PerlEval( @"@ARGV = @_; @ARGV = Win32::CommandLine::argv() if eval { require Win32::CommandLine }; use Getopt::Long qw(:config bundling bundling_override gnu_compat no_getopt_compat); (GetOptions (\%ARGV, 'help|h|?|usage', 'man', 'version|ver|v'), \@ARGV, \%ARGV);", args );

if ( String.IsNullOrEmpty(p.A[0].S) ) { string fname = tempPODfile(); p = PerlEval( @"$filename = @_[0]; use Pod::Usage; pod2usage({-input => $filename, -exitval => q{NOEXIT}});", new string[]{ fname } ); /* Console.WriteLine( "p = {0}", p.ToString()); */ File.Delete(fname); return 2; }

args = p.A[1].ToArray();
Dictionary<string,string> ARGS = p.A[2].ToDictionary();

string exeName = Application.ExecutablePath;	// [System.Windows.Forms] in Windows Forms
//string assName = Assembly.GetExecutingAssembly().GetName().ToString();

// ref: perldoc pod::usage [DESCRIPTION] for exit status
if (ARGS.ContainsKey("version")) { string fname = tempPODfile(); p = PerlEval( @"$filename = @_[0]; $name = @_[1]; $version = @_[2]; use Pod::Usage; pod2usage({-verbose => 99, -input => $filename, -exitval => q{NOEXIT}, -sections => '', -message => (File::Spec->splitpath($name))[2].qq{ v$version}});", new string[]{ fname, exeName, PerlEval( perlVERSION+'\n'+"$VERSION;" ).ToString() } ); /* Console.WriteLine( "p = {0}", p.ToString()); */ File.Delete(fname); return 1; }
if (ARGS.ContainsKey("help")) { string fname = tempPODfile(); p = PerlEval( @"$filename = @_[0]; use Pod::Usage; pod2usage({-input => $filename, -exitval => q{NOEXIT}});", new string[]{ fname } ); /* Console.WriteLine( "p = {0}", p.ToString()); */ File.Delete(fname); return 1; }
if (ARGS.ContainsKey("man")) { string fname = tempPODfile(); p = PerlEval( @"$filename = @_[0]; use Pod::Usage; pod2usage({-verbose => 2, -input => $filename, -exitval => q{NOEXIT}});", new string[]{ fname } ); /* Console.WriteLine( "p = {0}", p.ToString()); */ File.Delete(fname); return 1; }

string guid = System.Guid.NewGuid().ToString();

Console.WriteLine( guid );

return 0;
}

//[STAThread]
public static int Main(string[] args)
{
#if !DEBUG
    try
    {
#endif
        instance = new PROGRAM();
        instance.EnableDynamicLoadOfBoundDLLs();
        return instance.Start(args);
#if !DEBUG
    }
    catch (Exception ex)
    {
    	// [if mscript.ocx is unregistered: System.Runtime.InteropServices.COMException (0x80040154)]
        Console.WriteLine("Exception: " + ex);
    }
#endif

return 0;
}

private void EnableDynamicLoadOfBoundDLLs() 
{// call before Start()
    AppDomain.CurrentDomain.AssemblyResolve += delegate(object sender, ResolveEventArgs args)
    {
        //Console.WriteLine("In resolver for '"+args.Name+"'");
        string resName = args.Name.Split(',')[0] + ".dll";

        Assembly thisAssembly = Assembly.GetExecutingAssembly();
        using (Stream input = thisAssembly.GetManifestResourceStream(resName))
        {
            return input != null
                 ? Assembly.Load(StreamToBytes(input))
                 : null;
        }
    };
}

static byte[] StreamToBytes(Stream input) {
        int capacity = input.CanSeek ? (int)input.Length : 0;
        using (MemoryStream output = new MemoryStream(capacity)) {
            int readLength;
            byte[] buffer = new byte[4096];

            do {
                readLength = input.Read(buffer, 0, buffer.Length);
                output.Write(buffer, 0, readLength);
            }
            while (readLength != 0);

            return output.ToArray();
        }
}

}}	// class PROGRAM / namespace PROGRAM
