#!/usr/bin/env perl6
use v6;

use lib 'lib';
use Net::Curl::NativeCall;

# In windows, this will init the winsock stuff
curl_global_init(CURL_GLOBAL_ALL);

# get a curl handle
my $curl = curl_easy_init();
if $curl {
    # First set the URL that is about to receive our POST. This URL can
    # just as well be a https:// URL if that is what should receive the
    # data.
    curl_easy_setopt($curl, CURLOPT_URL, "http://postit.example.com/moo.cgi");

    # Now specify the POST data
    curl_easy_setopt($curl, CURLOPT_POSTFIELDS, 'name=daniel&project=curl');

    # Perform the request, res will get the return code */
    my $res = curl_easy_perform($curl);

    # Check for errors
    if $res != CURLE_OK {
      warn sprintf("curl_easy_perform failed: %s\n",
              curl_easy_strerror($res));
    }

    # always cleanup
    curl_easy_cleanup($curl);
  }

curl_global_cleanup;
