package Google::Ads::AdWords::v201806::Trial;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %baseCampaignId_of :ATTR(:get<baseCampaignId>);
my %draftId_of :ATTR(:get<draftId>);
my %budgetId_of :ATTR(:get<budgetId>);
my %name_of :ATTR(:get<name>);
my %startDate_of :ATTR(:get<startDate>);
my %endDate_of :ATTR(:get<endDate>);
my %trafficSplitPercent_of :ATTR(:get<trafficSplitPercent>);
my %status_of :ATTR(:get<status>);
my %trialCampaignId_of :ATTR(:get<trialCampaignId>);

__PACKAGE__->_factory(
    [ qw(        id
        baseCampaignId
        draftId
        budgetId
        name
        startDate
        endDate
        trafficSplitPercent
        status
        trialCampaignId

    ) ],
    {
        'id' => \%id_of,
        'baseCampaignId' => \%baseCampaignId_of,
        'draftId' => \%draftId_of,
        'budgetId' => \%budgetId_of,
        'name' => \%name_of,
        'startDate' => \%startDate_of,
        'endDate' => \%endDate_of,
        'trafficSplitPercent' => \%trafficSplitPercent_of,
        'status' => \%status_of,
        'trialCampaignId' => \%trialCampaignId_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'baseCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'draftId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'budgetId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'startDate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'endDate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'trafficSplitPercent' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'status' => 'Google::Ads::AdWords::v201806::TrialStatus',
        'trialCampaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'id' => 'id',
        'baseCampaignId' => 'baseCampaignId',
        'draftId' => 'draftId',
        'budgetId' => 'budgetId',
        'name' => 'name',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'trafficSplitPercent' => 'trafficSplitPercent',
        'status' => 'status',
        'trialCampaignId' => 'trialCampaignId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::Trial

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Trial from the namespace https://adwords.google.com/api/adwords/cm/v201806.

Interface for campaign trial entities. A trial is an experiment created by an advertiser from changes in a draft. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * id


=item * baseCampaignId


=item * draftId


=item * budgetId


=item * name


=item * startDate


=item * endDate


=item * trafficSplitPercent


=item * status


=item * trialCampaignId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

