=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::SwfExportOptions;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ExportOptions;
use AsposeSlidesCloud::Object::FontFallbackRule;
use AsposeSlidesCloud::Object::FontSubstRule;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Provides options that control how a presentation is saved in SWF format.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ format } = 'swf';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Provides options that control how a presentation is saved in SWF format.',
                                  class => 'SwfExportOptions',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'default_regular_font' => {
    	datatype => 'string',
    	base_name => 'DefaultRegularFont',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'gradient_style' => {
    	datatype => 'string',
    	base_name => 'GradientStyle',
    	description => 'Default regular font for rendering the presentation. ',
    	format => '',
    	read_only => '',
    		},
    'font_fallback_rules' => {
    	datatype => 'ARRAY[FontFallbackRule]',
    	base_name => 'FontFallbackRules',
    	description => 'Gets of sets list of font fallback rules.',
    	format => '',
    	read_only => '',
    		},
    'font_subst_rules' => {
    	datatype => 'ARRAY[FontSubstRule]',
    	base_name => 'FontSubstRules',
    	description => 'Gets of sets list of font substitution rules.',
    	format => '',
    	read_only => '',
    		},
    'format' => {
    	datatype => 'string',
    	base_name => 'Format',
    	description => 'Export format.',
    	format => '',
    	read_only => '',
    		},
    'show_hidden_slides' => {
    	datatype => 'boolean',
    	base_name => 'ShowHiddenSlides',
    	description => 'Specifies whether the generated document should include hidden slides or not. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'compressed' => {
    	datatype => 'boolean',
    	base_name => 'Compressed',
    	description => 'Specifies whether the generated SWF document should be compressed or not. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'viewer_included' => {
    	datatype => 'boolean',
    	base_name => 'ViewerIncluded',
    	description => 'Specifies whether the generated SWF document should include the integrated document viewer or not. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_page_border' => {
    	datatype => 'boolean',
    	base_name => 'ShowPageBorder',
    	description => 'Specifies whether border around pages should be shown. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_full_screen' => {
    	datatype => 'boolean',
    	base_name => 'ShowFullScreen',
    	description => 'Show/hide fullscreen button. Can be overridden in flashvars. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_page_stepper' => {
    	datatype => 'boolean',
    	base_name => 'ShowPageStepper',
    	description => 'Show/hide page stepper. Can be overridden in flashvars. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_search' => {
    	datatype => 'boolean',
    	base_name => 'ShowSearch',
    	description => 'Show/hide search section. Can be overridden in flashvars. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_top_pane' => {
    	datatype => 'boolean',
    	base_name => 'ShowTopPane',
    	description => 'Show/hide whole top pane. Can be overridden in flashvars. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_bottom_pane' => {
    	datatype => 'boolean',
    	base_name => 'ShowBottomPane',
    	description => 'Show/hide bottom pane. Can be overridden in flashvars. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'show_left_pane' => {
    	datatype => 'boolean',
    	base_name => 'ShowLeftPane',
    	description => 'Show/hide left pane. Can be overridden in flashvars. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'start_open_left_pane' => {
    	datatype => 'boolean',
    	base_name => 'StartOpenLeftPane',
    	description => 'Start with opened left pane. Can be overridden in flashvars. Default is false. ',
    	format => '',
    	read_only => '',
    		},
    'enable_context_menu' => {
    	datatype => 'boolean',
    	base_name => 'EnableContextMenu',
    	description => 'Enable/disable context menu. Default is true. ',
    	format => '',
    	read_only => '',
    		},
    'logo_image' => {
    	datatype => 'string',
    	base_name => 'LogoImage',
    	description => 'Image that will be displayed as logo in the top right corner of the viewer. The image data is a base 64 string. Image should be 32x64 pixels PNG image, otherwise logo can be displayed improperly. ',
    	format => '',
    	read_only => '',
    		},
    'logo_link' => {
    	datatype => 'string',
    	base_name => 'LogoLink',
    	description => 'Gets or sets the full hyperlink address for a logo. Has an effect only if a LogoImage is specified. ',
    	format => '',
    	read_only => '',
    		},
    'jpeg_quality' => {
    	datatype => 'int',
    	base_name => 'JpegQuality',
    	description => 'Specifies the quality of JPEG images. Default is 95.',
    	format => '',
    	read_only => '',
    		},
    'notes_position' => {
    	datatype => 'string',
    	base_name => 'NotesPosition',
    	description => 'Gets or sets the position of the notes on the page.',
    	format => '',
    	read_only => '',
    		},
    'comments_position' => {
    	datatype => 'string',
    	base_name => 'CommentsPosition',
    	description => 'Gets or sets the position of the comments on the page.',
    	format => '',
    	read_only => '',
    		},
    'comments_area_width' => {
    	datatype => 'int',
    	base_name => 'CommentsAreaWidth',
    	description => 'Gets or sets the width of the comment output area in pixels (Applies only if comments are displayed on the right).',
    	format => '',
    	read_only => '',
    		},
    'comments_area_color' => {
    	datatype => 'string',
    	base_name => 'CommentsAreaColor',
    	description => 'Gets or sets the color of comments area (Applies only if comments are displayed on the right).',
    	format => '',
    	read_only => '',
    		},
    'show_comments_by_no_author' => {
    	datatype => 'boolean',
    	base_name => 'ShowCommentsByNoAuthor',
    	description => 'True if comments that have no author are displayed. (Applies only if comments are displayed).',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'default_regular_font' => 'string',
    'gradient_style' => 'string',
    'font_fallback_rules' => 'ARRAY[FontFallbackRule]',
    'font_subst_rules' => 'ARRAY[FontSubstRule]',
    'format' => 'string',
    'show_hidden_slides' => 'boolean',
    'compressed' => 'boolean',
    'viewer_included' => 'boolean',
    'show_page_border' => 'boolean',
    'show_full_screen' => 'boolean',
    'show_page_stepper' => 'boolean',
    'show_search' => 'boolean',
    'show_top_pane' => 'boolean',
    'show_bottom_pane' => 'boolean',
    'show_left_pane' => 'boolean',
    'start_open_left_pane' => 'boolean',
    'enable_context_menu' => 'boolean',
    'logo_image' => 'string',
    'logo_link' => 'string',
    'jpeg_quality' => 'int',
    'notes_position' => 'string',
    'comments_position' => 'string',
    'comments_area_width' => 'int',
    'comments_area_color' => 'string',
    'show_comments_by_no_author' => 'boolean'
} );

__PACKAGE__->attribute_map( {
    'default_regular_font' => 'DefaultRegularFont',
    'gradient_style' => 'GradientStyle',
    'font_fallback_rules' => 'FontFallbackRules',
    'font_subst_rules' => 'FontSubstRules',
    'format' => 'Format',
    'show_hidden_slides' => 'ShowHiddenSlides',
    'compressed' => 'Compressed',
    'viewer_included' => 'ViewerIncluded',
    'show_page_border' => 'ShowPageBorder',
    'show_full_screen' => 'ShowFullScreen',
    'show_page_stepper' => 'ShowPageStepper',
    'show_search' => 'ShowSearch',
    'show_top_pane' => 'ShowTopPane',
    'show_bottom_pane' => 'ShowBottomPane',
    'show_left_pane' => 'ShowLeftPane',
    'start_open_left_pane' => 'StartOpenLeftPane',
    'enable_context_menu' => 'EnableContextMenu',
    'logo_image' => 'LogoImage',
    'logo_link' => 'LogoLink',
    'jpeg_quality' => 'JpegQuality',
    'notes_position' => 'NotesPosition',
    'comments_position' => 'CommentsPosition',
    'comments_area_width' => 'CommentsAreaWidth',
    'comments_area_color' => 'CommentsAreaColor',
    'show_comments_by_no_author' => 'ShowCommentsByNoAuthor'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
